

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
time_intervals = np.array([1, 2, 3, 4, 5, 6])
average_heart_rate = np.random.uniform(60, 100, len(time_intervals))  # Average heart rate data
stressed_heart_rate = np.random.uniform(70, 110, len(time_intervals))  # Stressed heart rate data

# Axes Limits and Labels
xlabel_value = "Time (Months)"
ylabel_value = "Heart Rate (BPM)"

ylim_values = [50, 120]
yticks_values = [50, 60, 70, 80, 90, 100, 110, 120]
yticks_labels = ["50 BPM", "60 BPM", "70 BPM", "80 BPM", "90 BPM", "100 BPM", "110 BPM", "120 BPM"]

# Labels
label_Average = "Average Heart Rate"
label_Stressed = "Stressed Heart Rate"
chart_title = "Heart Rate Change Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 6))

# Plot the data
plt.plot(
    time_intervals,
    average_heart_rate,
    "o-",
    color="#008080",  # Teal color for Average
    label=label_Average,
    markerfacecolor="#008080",
    markersize=6,
    linewidth=2
)
plt.plot(
    time_intervals,
    stressed_heart_rate,
    "s--",
    color="#FF7F50",  # Coral color for Stressed
    label=label_Stressed,
    markerfacecolor="#FF7F50",
    markersize=6,
    linewidth=2
)

# Add labels with increased font size
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)

# Add title
plt.title(chart_title, fontsize=16)

# Set y-axis ticks and labels
plt.yticks(yticks_values, yticks_labels)
plt.ylim(ylim_values)

# Adjust the tick params for both axes
plt.tick_params(axis="both", labelsize=12)

# Add legend with transparent background
plt.legend(frameon=True, fontsize=12)

# Add grid lines for better readability
plt.grid(True, which="both", linestyle="--", linewidth=0.5, color='grey')

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout for a better fit
plt.tight_layout()
plt.savefig("line_88.pdf", bbox_inches="tight")
