
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data: Quarterly GDP growth rates (in %) for four different countries
quarters = np.array([1, 2, 3, 4])
country1_gdp = np.array([1.5, 2.0, 2.3, 1.8])
country1_err = np.array([0.2, 0.3, 0.3, 0.2])

country2_gdp = np.array([2.1, 2.5, 2.8, 2.4])
country2_err = np.array([0.3, 0.3, 0.2, 0.3])

country3_gdp = np.array([1.2, 1.6, 1.9, 1.5])
country3_err = np.array([0.2, 0.2, 0.3, 0.2])

country4_gdp = np.array([3.0, 3.2, 3.5, 3.1])
country4_err = np.array([0.4, 0.3, 0.4, 0.3])

# Axes Labels and Titles
xlabel = "Quarter"
ylabel = "GDP Growth Rate (%)"
title_1 = "Country 1: Quarterly GDP Growth"
title_2 = "Country 2: Quarterly GDP Growth"
title_3 = "Country 3: Quarterly GDP Growth"
title_4 = "Country 4: Quarterly GDP Growth"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors and Styles
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]
line_styles = ["-", "--", "-.", ":"]
marker_shapes = ["o", "s", "^", "D"]

# Create subplots
fig, axs = plt.subplots(1, 4, figsize=(16, 5))

# Global settings for all axes
for ax in axs:
    ax.tick_params(axis="both", which="major", labelsize=12)
    ax.set_xlabel(xlabel, fontsize=14)
    ax.set_ylabel(ylabel, fontsize=14)
    ax.grid(True, alpha=0.3)

# Plot Country 1
axs[0].errorbar(
    quarters, country1_gdp, yerr=country1_err, fmt=marker_shapes[0], linestyle=line_styles[0], 
    color=colors[0], ecolor=colors[0], capsize=4, markersize=6
)
axs[0].fill_between(quarters, country1_gdp - country1_err, country1_gdp + country1_err, color=colors[0], alpha=0.2)
axs[0].set_title(title_1, fontsize=12)

# Plot Country 2
axs[1].errorbar(
    quarters, country2_gdp, yerr=country2_err, fmt=marker_shapes[1], linestyle=line_styles[1], 
    color=colors[1], ecolor=colors[1], capsize=4, markersize=6
)
axs[1].fill_between(quarters, country2_gdp - country2_err, country2_gdp + country2_err, color=colors[1], alpha=0.2)
axs[1].set_title(title_2, fontsize=12)

# Plot Country 3
axs[2].errorbar(
    quarters, country3_gdp, yerr=country3_err, fmt=marker_shapes[2], linestyle=line_styles[2], 
    color=colors[2], ecolor=colors[2], capsize=4, markersize=6
)
axs[2].fill_between(quarters, country3_gdp - country3_err, country3_gdp + country3_err, color=colors[2], alpha=0.2)
axs[2].set_title(title_3, fontsize=12)

# Plot Country 4
axs[3].errorbar(
    quarters, country4_gdp, yerr=country4_err, fmt=marker_shapes[3], linestyle=line_styles[3], 
    color=colors[3], ecolor=colors[3], capsize=4, markersize=6
)
axs[3].fill_between(quarters, country4_gdp - country4_err, country4_gdp + country4_err, color=colors[3], alpha=0.2)
axs[3].set_title(title_4, fontsize=12)

# Adjust layout
plt.subplots_adjust(wspace=0.3)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_89.pdf", bbox_inches="tight")
