
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate new sample data for the weather domain
np.random.seed(42)
# Temperature data
x1 = np.array([1, 2, 3, 4, 5, 6, 7])
y1 = np.array([22, 24, 19, 23, 21, 20, 25])
e1 = np.array([2, 1, 3, 2, 1, 2, 3])

# Precipitation data
x2 = np.array([1, 2, 3, 4, 5, 6, 7])
y2 = np.array([10, 5, 8, 12, 7, 9, 5])
e2 = np.array([1, 2, 1, 2, 1, 2, 1])

# Humidity data
x3 = np.array([0, 4, 8, 12, 16, 20, 24])
y3 = np.array([65, 70, 75, 80, 85, 75, 65])
e3 = np.array([5, 4, 3, 5, 4, 3, 4])

# Wind speed data
x4 = np.array([100, 200, 300, 400, 500])
y4 = np.array([18, 20, 15, 25, 22])
e4 = np.array([2, 3, 2, 3, 2])

# Axes Limits and Labels
xlim_values_1 = [0.8, 7.2]
xticks_values_1 = [1, 2, 3, 4, 5, 6, 7]
xlim_values_2 = [0.8, 7.2]
xticks_values_2 = [1, 2, 3, 4, 5, 6, 7]
xlim_values_3 = [-1, 25]
xticks_values_3 = np.arange(0, 25, 4)
xlim_values_4 = [90, 510]
xticks_values_4 = np.arange(100, 501, 100)

ylim_values_1 = [17, 27]
yticks_values_1 = range(18, 27, 2)
ylim_values_2 = [4, 14]
yticks_values_2 = range(5, 14, 2)
ylim_values_3 = [60, 90]
yticks_values_3 = np.arange(65, 90, 5)
ylim_values_4 = [12, 28]
yticks_values_4 = np.arange(15, 28, 3)

# Labels
xlabel_1 = "Day"
ylabel_1 = "Temperature (°C)"
xlabel_2 = "Day"
ylabel_2 = "Precipitation (mm)"
xlabel_3 = "Time (hours)"
ylabel_3 = "Humidity (%)"
xlabel_4 = "Altitude (m)"
ylabel_4 = "Wind Speed (km/h)"

# Titles
title_1 = "(a) Daily Temperature."
title_2 = "(b) Daily Precipitation."
title_3 = "(c) Hourly Humidity."
title_4 = "(d) Wind Speed at Different Altitudes."

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, axs = plt.subplots(1, 4, figsize=(14, 4))

# Global settings for all axes
for ax in axs:
    ax.tick_params(axis="both", which="major", labelsize=12)

# Set the specified x and y axis ranges for the first plot
axs[0].set_xlim(xlim_values_1)
axs[0].set_ylim(ylim_values_1)
axs[0].set_xticks(xticks_values_1)
axs[0].set_yticks(yticks_values_1)
axs[0].set_xlabel(xlabel_1, fontsize=12)
axs[0].set_ylabel(ylabel_1, fontsize=12)

# For the second plot
axs[1].set_xlim(xlim_values_2)
axs[1].set_ylim(ylim_values_2)
axs[1].set_xticks(xticks_values_2)
axs[1].set_yticks(yticks_values_2)
axs[1].set_xlabel(xlabel_2, fontsize=12)
axs[1].set_ylabel(ylabel_2, fontsize=12)

# For the third plot
axs[2].set_xlim(xlim_values_3)
axs[2].set_ylim(ylim_values_3)
axs[2].set_xticks(xticks_values_3)
axs[2].set_yticks(yticks_values_3)
axs[2].set_xlabel(xlabel_3, fontsize=12)
axs[2].set_ylabel(ylabel_3, fontsize=12)

# For the fourth plot
axs[3].set_xlim(xlim_values_4)
axs[3].set_ylim(ylim_values_4)
axs[3].set_xticks(xticks_values_4)
axs[3].set_yticks(yticks_values_4)
axs[3].set_xlabel(xlabel_4, fontsize=12)
axs[3].set_ylabel(ylabel_4, fontsize=12)

# Plot with error bands
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

axs[0].errorbar(x1, y1, yerr=e1, fmt="-o", color=colors[0], ecolor="#aec7e8", capsize=5, markersize=6)
axs[0].fill_between(x1, y1 - e1, y1 + e1, color="#1f77b4", alpha=0.2)
axs[0].set_title(title_1, y=-0.3, fontsize=14)
axs[0].grid(True, alpha=0.3)

axs[1].errorbar(x2, y2, yerr=e2, fmt="--s", color=colors[1], ecolor="#ffbb78", capsize=5, markersize=6)
axs[1].fill_between(x2, y2 - e2, y2 + e2, color="#ff7f0e", alpha=0.2)
axs[1].set_title(title_2, y=-0.3, fontsize=14)
axs[1].grid(True, alpha=0.3)

axs[2].errorbar(x3, y3, yerr=e3, fmt="-.d", color=colors[2], ecolor="#98df8a", capsize=5, markersize=6)
axs[2].fill_between(x3, y3 - e3, y3 + e3, color="#2ca02c", alpha=0.2)
axs[2].set_title(title_3, y=-0.3, fontsize=14)
axs[2].grid(True, alpha=0.3)

axs[3].errorbar(x4, y4, yerr=e4, fmt=":p", color=colors[3], ecolor="#ff9896", capsize=5, markersize=6)
axs[3].fill_between(x4, y4 - e4, y4 + e4, color="#d62728", alpha=0.2)
axs[3].set_title(title_4, y=-0.3, fontsize=14)
axs[3].grid(True, alpha=0.3)

# Adjust layout
plt.subplots_adjust(wspace=0.4)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_90.pdf", bbox_inches="tight")
