
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for daily average temperature (in Celsius) for different cities over a week
days = np.array([1, 2, 3, 4, 5, 6, 7])
city_a_temp = np.array([22, 23, 21, 25, 24, 22, 20])
error_a = np.array([1, 1.2, 1.1, 1.3, 1.2, 1.1, 1.2])

city_b_temp = np.array([19, 18, 20, 21, 22, 23, 21])
error_b = np.array([1.1, 1.3, 1.2, 1.4, 1.3, 1.2, 1.3])

city_c_temp = np.array([25, 26, 27, 28, 27, 26, 25])
error_c = np.array([0.9, 1.0, 1.1, 0.8, 1.0, 0.9, 1.0])

city_d_temp = np.array([20, 21, 22, 23, 22, 21, 20])
error_d = np.array([1.2, 1.3, 1.1, 1.4, 1.2, 1.3, 1.2])

# Axes Limits and Labels
xlim_values = [0.8, 7.2]
xticks_values = [1, 2, 3, 4, 5, 6, 7]

ylim_values_1 = [18, 27]
yticks_values_1 = range(18, 28, 2)
ylim_values_2 = [17, 25]
yticks_values_2 = range(17, 26, 2)
ylim_values_3 = [24, 30]
yticks_values_3 = range(24, 31, 1)
ylim_values_4 = [19, 24]
yticks_values_4 = range(19, 25, 1)

# Labels
xlabel = "Days"
ylabel = "Temperature (°C)"

label_a = "City A"
label_b = "City B"
label_c = "City C"
label_d = "City D"

# Titles
title_a = "City A Temperature Over a Week"
title_b = "City B Temperature Over a Week"
title_c = "City C Temperature Over a Week"
title_d = "City D Temperature Over a Week"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, axs = plt.subplots(1, 4, figsize=(16, 5))

# Global settings for all axes
for ax in axs:
    ax.tick_params(axis="both", which="major", labelsize=12)
    ax.set_xlabel(xlabel, fontsize=14)
    ax.set_ylabel(ylabel, fontsize=14)

# Set the specified x and y axis ranges and ticks
axs[0].set_xlim(xlim_values)
axs[0].set_ylim(ylim_values_1)
axs[0].set_xticks(xticks_values)
axs[0].set_yticks(yticks_values_1)

axs[1].set_xlim(xlim_values)
axs[1].set_ylim(ylim_values_2)
axs[1].set_xticks(xticks_values)
axs[1].set_yticks(yticks_values_2)

axs[2].set_xlim(xlim_values)
axs[2].set_ylim(ylim_values_3)
axs[2].set_xticks(xticks_values)
axs[2].set_yticks(yticks_values_3)

axs[3].set_xlim(xlim_values)
axs[3].set_ylim(ylim_values_4)
axs[3].set_xticks(xticks_values)
axs[3].set_yticks(yticks_values_4)

# Plot with error bands
axs[0].errorbar(
    days, city_a_temp, yerr=error_a, fmt="--s", color="darkorange", ecolor="orange", capsize=5, markersize=6
)
axs[0].fill_between(days, city_a_temp - error_a, city_a_temp + error_a, color="orange", alpha=0.2)
axs[0].set_title(title_a, y=-0.2, fontsize=14)
axs[0].grid(True, alpha=0.5)

axs[1].errorbar(
    days, city_b_temp, yerr=error_b, fmt="--d", color="dodgerblue", ecolor="deepskyblue", capsize=5, markersize=6
)
axs[1].fill_between(days, city_b_temp - error_b, city_b_temp + error_b, color="deepskyblue", alpha=0.2)
axs[1].set_title(title_b, y=-0.2, fontsize=14)
axs[1].grid(True, alpha=0.5)

axs[2].errorbar(
    days, city_c_temp, yerr=error_c, fmt="--o", color="forestgreen", ecolor="limegreen", capsize=5, markersize=6
)
axs[2].fill_between(days, city_c_temp - error_c, city_c_temp + error_c, color="limegreen", alpha=0.2)
axs[2].set_title(title_c, y=-0.2, fontsize=14)
axs[2].grid(True, alpha=0.5)

axs[3].errorbar(
    days, city_d_temp, yerr=error_d, fmt="--^", color="indianred", ecolor="salmon", capsize=5, markersize=6
)
axs[3].fill_between(days, city_d_temp - error_d, city_d_temp + error_d, color="salmon", alpha=0.2)
axs[3].set_title(title_d, y=-0.2, fontsize=14)
axs[3].grid(True, alpha=0.5)

# Adjust layout
plt.subplots_adjust(wspace=0.4)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_91.pdf", bbox_inches="tight")
