
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
years = ["2000", "2005", "2010", "2015", "2020"]
population_country_a = [50.0, 55.0, 60.0, 65.0, 70.0]
population_country_b = [40.0, 45.5, 50.0, 55.5, 60.0]
error = [2.0, 2.2, 2.3, 2.5, 2.7]

# Axes Limits and Labels
xlabel_value = "Year"
ylabel_value = "Population (Millions)"
ylim_values = [30, 80]

# Labels
label_Country_A = "Country A"
label_Country_B = "Country B"

# Titles
title = "Countries"
supertitle = "Population Growth Over Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(8, 6))
ax.errorbar(
    years,
    population_country_a,
    yerr=error,
    fmt="o-",
    color="#1f77b4",  # Blue
    ecolor="#1f77b4",
    elinewidth=2,
    capsize=5,
    capthick=2,
    label=label_Country_A,
    markerfacecolor='#aec7e8'
)
ax.errorbar(
    years,
    population_country_b,
    yerr=error,
    fmt="s-",
    color="#ff7f0e",  # Orange
    ecolor="#ff7f0e",
    elinewidth=2,
    capsize=5,
    capthick=2,
    label=label_Country_B,
    markerfacecolor='#ffbb78'
)

# Customization
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_ylim(ylim_values)

ax.tick_params(
    axis="both", which="major", length=6, direction="in", top=True, right=True
)
ax.legend(title=title, loc="lower right", frameon=False)
fig.suptitle(supertitle, fontsize=16)
ax.set_title("")

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("line_92.pdf", bbox_inches="tight")
