

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for Historical Events and Impact Scores Over Two Decades
categories = ["Technology", "Politics", "Economy", "Health", "Environment"]
impact_2000s = [70, 65, 80, 60, 75]
impact_2010s = [85, 70, 90, 78, 80]
error_margin = [5, 6, 4, 5, 6]

# Axes Limits and Labels
xlabel_value = "Category"
ylabel_value = "Impact Score"
ylim_values = [50, 100]

# Labels
label_2000s = "2000s"
label_2010s = "2010s"

# Titles
title = "Decade"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(8, 6))
ax.errorbar(
    categories,
    impact_2000s,
    yerr=error_margin,
    fmt="*-",
    color="teal",
    ecolor="teal",
    elinewidth=2,
    capsize=5,
    capthick=2,
    label=label_2000s,
    linestyle='--'
)
ax.errorbar(
    categories,
    impact_2010s,
    yerr=error_margin,
    fmt="H-",
    color="magenta",
    ecolor="magenta",
    elinewidth=2,
    capsize=5,
    capthick=2,
    label=label_2010s,
    linestyle='-.'
)

# Customization
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)

ax.tick_params(
    axis="both", which="major", length=5, direction="in", top=True, right=True
)
ax.legend(title=title, loc="upper left", frameon=False)
ax.set_ylim(ylim_values)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("line_93.pdf", bbox_inches="tight")

