
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
subjects = ["Math", "Science", "History", "Literature"]
scores_traditional = [76, 81, 70, 74]
scores_modern = [82, 85, 78, 80]
error = [4, 3, 5, 4]

# Axes Limits and Labels
xlabel_value = "Subject"
ylabel_value = "Average Score"
ylim_values = [60, 90]

# Labels
label_Traditional_Method = "Traditional Method"
label_Modern_Method = "Modern Method"

# Titles
title = "Teaching Methodologies"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(8, 6))
color_traditional = "navy"
ecolor_traditional = "skyblue"
color_modern = "green"
ecolor_modern = "lightgreen"

ax.errorbar(
    subjects,
    scores_traditional,
    yerr=error,
    fmt="h-",
    color=color_traditional,
    ecolor=ecolor_traditional,
    elinewidth=2,
    capsize=5,
    capthick=2,
    label=label_Traditional_Method,
)
ax.errorbar(
    subjects,
    scores_modern,
    yerr=error,
    fmt="d--",
    color=color_modern,
    ecolor=ecolor_modern,
    elinewidth=2,
    capsize=5,
    capthick=2,
    label=label_Modern_Method,
)

# Customization
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)

ax.tick_params(
    axis="both", which="major", length=5, direction="in", top=True, right=True
)
ax.legend(title=title, loc="upper left", frameon=False)
ax.set_ylim(ylim_values)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("line_94.pdf", bbox_inches="tight")
