

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for geography domain
regions = ["North", "South", "East", "West", "Central", "North-East", "South-West", "North-West"]
temperature = [15, 18, 20, 16, 22, 14, 19, 17]
rainfall = [200, 150, 180, 220, 160, 210, 170, 190]
humidity = [55, 60, 65, 58, 62, 54, 63, 59]

# Positions for the bars on the x-axis
ind = np.arange(len(regions))

# Labels and Legend
xlabel = "Regions"
ylabel = "Metrics"
temperature_label = "Temperature (°C)"
rainfall_label = "Rainfall (mm)"
humidity_label = "Humidity (%)"

# Limits
xlim = (regions[0], regions[-1])
ylim = (0, 250)
title="Geographical Metrics by Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 6))  # Adjust the size to match the original image's dimensions
ax.plot(regions, temperature, label=temperature_label, color="#2ca02c", linestyle='-', marker='o', linewidth=2)
ax.plot(regions, rainfall, label=rainfall_label, color="#d62728", linestyle='--', marker='s', linewidth=2)
ax.plot(regions, humidity, label=humidity_label, color="#1f77b4", linestyle=':', marker='^', linewidth=2)

# Setting the x-axis and y-axis limits
ax.set_ylim(*ylim)  # Set y-axis to go from 0 to 250
ax.set_xlim(*xlim)  # Set x-axis limits to cover the range of regions without extra space

# Labels and Title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16, fontweight='bold')

# Legend
ax.legend(loc="upper center", fontsize=14, frameon=False, ncol=3, bbox_to_anchor=(0.5, 1.15))

# Grid
ax.grid(True, ls="--", alpha=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_98.pdf", bbox_inches="tight")

