

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug"]
email_engagement = [50, 55, 53, 58, 57, 60, 62, 65]
social_media_engagement = [40, 42, 44, 46, 48, 50, 52, 55]
phone_engagement = [30, 33, 31, 35, 37, 40, 38, 42]
in_person_engagement = [20, 25, 23, 28, 27, 30, 32, 35]

# Positions for the bars on the x-axis
ind = np.arange(len(months))

# Labels and Legend
xlabel = "Months"
ylabel = "Engagement Level"
title = "Engagement Level Over Time Across Communication Channels"
email_label = "Email"
social_media_label = "Social Media"
phone_label = "Phone"
in_person_label = "In-person"

# Limits
xlim = (months[0], months[-1])
ylim = (0, 70)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 7))
ax.plot(months, email_engagement, label=email_label, color="#4C72B0", linestyle='-', marker='o', linewidth=2)
ax.plot(months, social_media_engagement, label=social_media_label, color="#55A868", linestyle='--', marker='s', linewidth=2)
ax.plot(months, phone_engagement, label=phone_label, color="#C44E52", linestyle='-.', marker='d', linewidth=2)
ax.plot(months, in_person_engagement, label=in_person_label, color="#8172B3", linestyle=':', marker='x', linewidth=2)

# Setting the x-axis and y-axis limits
ax.set_ylim(*ylim)  # Set y-axis to go from 0 to 70
ax.set_xlim(*xlim)  # Set x-axis limits to cover the range of months without extra space

# Labels and Title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16, pad=20)

# Legend
ax.legend(loc="upper left", fontsize=12, frameon=True, fancybox=True, shadow=True)

# Grid
ax.grid(True, ls="--", alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_99.pdf", bbox_inches="tight")

