
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for Picture in Picture bar plot
known_crop_yields = np.array([5000, 4800, 4600, 4400, 4200, 4000, 3800, 3600, 3400, 3200, 3000])
unknown_crop_yields = np.array([2500, 2400, 2300, 2200, 2100, 2000, 1900, 1800, 1700, 1600, 1500])
bins = np.linspace(0, 0.5, 11)

# Data for the heatmap
crop_ratings = np.array([
    [3.5, 3.8, 4.0, 4.2, 4.5],
    [3.6, 3.9, 4.1, 4.3, 4.6],
    [3.7, 4.0, 4.2, 4.4, 4.7],
    [3.8, 4.1, 4.3, 4.5, 4.8],
    [3.9, 4.2, 4.4, 4.6, 4.9],
])
x_labels = ["Wheat", "Rice", "Corn", "Barley", "Soybean"]
y_labels = ["Region A", "Region B", "Region C", "Region D", "Region E"]
bar_labels = ["Known Crops", "Unknown Crops"]
xlabels = ["Crop Yields by Region", "Crop Types"]
ylabels = ["Crop Yield (tons)", "Regions"]
cbarlabel = "Crop Ratings"
insetaxes = [0.281, 0.7, 0.1, 0.2]
insetxlim = [0.25, 0.5]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with GridSpec
fig = plt.figure(figsize=(14, 6))
gs = gridspec.GridSpec(1, 2, width_ratios=[1, 1.5])

# Picture in Picture bar plot
ax0 = plt.subplot(gs[0])
ax0.bar(bins, known_crop_yields, width=0.04, color="#1f77b4", align="center", label=bar_labels[0], edgecolor="black")
ax0.bar(bins, unknown_crop_yields, width=0.04, color="#ff7f0e", align="center", bottom=known_crop_yields, label=bar_labels[1], edgecolor="black")
ax0.set_xlabel(xlabels[0])
ax0.set_ylabel(ylabels[0])
ax0.set_ylim(0,8500)
ax0.legend(loc="upper right")
ax0.grid(True)

# Add inset
ax_inset = fig.add_axes(insetaxes)
ax_inset.bar(bins[5:], known_crop_yields[5:], width=0.04, color="#1f77b4", align="center", edgecolor="black")
ax_inset.bar(bins[5:], unknown_crop_yields[5:], width=0.04, color="#ff7f0e", align="center", bottom=known_crop_yields[5:], edgecolor="black")
ax_inset.set_xlim(insetxlim)


# Heatmap plot
ax1 = plt.subplot(gs[1])
cmap = plt.cm.viridis_r
norm = plt.Normalize(vmin=crop_ratings.min(), vmax=crop_ratings.max())
heatmap = ax1.imshow(crop_ratings, cmap=cmap, norm=norm, aspect="auto")

# Add color bar
cbar = plt.colorbar(heatmap, ax=ax1, orientation="vertical", pad=0.1)
cbar.set_label(cbarlabel)

# Set x and y labels
ax1.set_xticks(np.arange(len(x_labels)))
ax1.set_yticks(np.arange(len(y_labels)))
ax1.set_xticklabels(x_labels, rotation=45)
ax1.set_yticklabels(y_labels)
ax1.set_xlabel(xlabels[1])
ax1.set_ylabel(ylabels[1])

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("multidiff_100.pdf", bbox_inches="tight")
