

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the histogram: energy consumption rates in different sectors
energy_consumption_residential = np.random.normal(loc=300, scale=50, size=1000)
energy_consumption_commercial = np.random.normal(loc=500, scale=80, size=1000)

# Data for the pie chart: budget allocation for energy projects
labels = ["Renewable Energy", "Infrastructure", "Research", "Public Awareness", "Administration"]
budget = [40, 30, 15, 10, 5]
explode = (0.1, 0, 0, 0, 0)  # highlight the largest segment
titles = ["Energy Consumption Rates in Different Sectors", "Budget Allocation for Energy Projects"]
xlabel = "Energy Consumption (kWh)"
ylabel = "Number of Records"
histlabels = ["Residential", "Commercial"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]
# Set up the figure and grid
fig = plt.figure(figsize=(10, 5))
gs = gridspec.GridSpec(1, 2, figure=fig)

# Histogram plot
axes1 = fig.add_subplot(gs[0, 0])
axes1.hist(
    [energy_consumption_residential, energy_consumption_commercial],
    bins=50,
    stacked=True,
    color=["#1f77b4", "#d62728"],
    label=histlabels,
)
axes1.set_title(titles[0])
axes1.set_xlabel(xlabel)
axes1.set_ylabel(ylabel)
axes1.legend(loc="upper right")

# Pie chart plot
axes2 = fig.add_subplot(gs[0, 1])
axes2.pie(
    budget,
    explode=explode,
    labels=labels,
    colors=colors,
    autopct="%1.1f%%",
    shadow=True,
    startangle=140,
)
axes2.set_title(titles[1])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("multidiff_29.pdf", bbox_inches="tight")
