

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the histogram: message distribution in urban vs. rural areas
messages_sent_urban = np.random.normal(loc=50, scale=15, size=1000)
messages_sent_rural = np.random.normal(loc=30, scale=10, size=1000)

# Data for the pie chart: modes of communication
labels = ["Social Media", "Email", "Phone", "Face-to-face", "Video Calls"]
communication_modes = [30, 20, 15, 25, 10]
explode = (0, 0, 0.1, 0, 0)  # highlighting 'Face-to-face' mode
titles = ["Daily Messages Sent in Urban vs. Rural Areas", "Modes of Communication"]
xlabel = "Number of Messages Sent"
ylabel = "Number of People"
histlabels = ["Urban", "Rural"]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up the figure and grid
fig = plt.figure(figsize=(12, 6))  # Slightly larger figure for better readability
gs = gridspec.GridSpec(1, 2, figure=fig)

# Optimization: Enhanced Color Scheme
colors = ["#2E86C1", "#1ABC9C", "#F39C12", "#E74C3C", "#9B59B6"]

# Histogram plot
axes1 = fig.add_subplot(gs[0, 0])
axes1.hist(
    [messages_sent_urban, messages_sent_rural],
    bins=30,
    stacked=True,
    color=["#2E86C1", "#E74C3C"],  # New color scheme for histogram bars
    label=histlabels,
)
axes1.set_title(titles[0], fontsize=14, fontweight='bold')
axes1.set_xlabel(xlabel, fontsize=12)
axes1.set_ylabel(ylabel, fontsize=12)
axes1.legend(loc="upper right")

# Pie chart plot
axes2 = fig.add_subplot(gs[0, 1])
axes2.pie(
    communication_modes,
    explode=explode,
    labels=labels,
    colors=colors,
    autopct="%1.1f%%",
    shadow=True,
    startangle=90,
    textprops={'fontsize': 11}
)
axes2.set_title(titles[1], fontsize=14, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("multidiff_30.pdf", bbox_inches="tight")

