

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.gridspec import GridSpec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate sample data for the histogram representing housing data
house_prices = np.random.normal(loc=300000, scale=75000, size=1000)  # House prices in USD
household_income = np.random.normal(loc=60000, scale=15000, size=1000)  # Household income in USD

# Generate sample data for the scatter plot representing household characteristics
num_bedrooms = np.random.randint(1, 6, 100)
house_size = np.random.normal(2000, 500, 100)  # House size in square feet
lot_size = np.random.normal(8000, 2000, 100)  # Lot size in square feet

ax1title = "Histogram of Housing Data"
ax1xlabel = "Value (USD)"
ax1ylabel = "Frequency"
ax1legend = ["House Prices", "Household Income"]
ax2title = "Household Characteristics"
ax2labels = ["Bedrooms vs House Size", "Bedrooms vs Lot Size"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Histogram for housing data
# Create a figure and a 1x2 grid layout
fig = plt.figure(figsize=(10, 5))
gs = GridSpec(1, 2, figure=fig)

ax1 = fig.add_subplot(gs[0, 0])
ax1.hist(
    [house_prices, household_income], bins=50, stacked=True, color=["#7fc97f", "#beaed4"], alpha=0.7
)
ax1.set_title(ax1title)
ax1.set_xlabel(ax1xlabel)
ax1.set_ylabel(ax1ylabel)
ax1.legend(ax1legend)

# Scatter plot for household characteristics
ax2 = fig.add_subplot(gs[0, 1])
ax2.scatter(num_bedrooms, house_size, c="#fdc086", label=ax2labels[0], marker='^')
ax2.scatter(num_bedrooms, lot_size, c="#386cb0", label=ax2labels[1], marker='o')
ax2.set_title(ax2title)
ax2.legend()
ax2.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save to file
plt.tight_layout()
plt.savefig("multidiff_32.pdf", bbox_inches="tight")

