
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.gridspec import GridSpec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate sample data for the histogram representing age distribution in two cities
city_a_ages = np.random.normal(loc=35, scale=10, size=1000)  # Average age of 35 years with 10 years variance
city_b_ages = np.random.normal(loc=30, scale=8, size=1000)   # Average age of 30 years with 8 years variance

# Generate sample data for the scatter plot representing population density in districts of the same cities
districts = np.random.uniform(1, 20, 100)
pop_density_city_a = np.random.normal(3000, 500, 100)
pop_density_city_b = np.random.normal(2500, 400, 100)

ax1title = "Age Distribution of Two Cities"
ax1xlabel = "Age"
ax1ylabel = "Frequency"
ax1legend = ["City A", "City B"]
ax2title = "Population Density in Districts"
ax2labels = ["City A", "City B"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and a 1x2 grid layout
fig = plt.figure(figsize=(10, 5))
gs = GridSpec(1, 2, figure=fig)

# Histogram for age distribution
ax1 = fig.add_subplot(gs[0, 0])
ax1.hist([city_a_ages, city_b_ages], bins=50, stacked=True, color=["#1f77b4", "#ff7f0e"], alpha=0.7)
ax1.set_title(ax1title)
ax1.set_xlabel(ax1xlabel)
ax1.set_ylabel(ax1ylabel)
ax1.legend(ax1legend)

# Scatter plot for population density
ax2 = fig.add_subplot(gs[0, 1])
ax2.scatter(districts, pop_density_city_a, c="#2ca02c", marker="o", label=ax2labels[0])
ax2.scatter(districts, pop_density_city_b, c="#d62728", marker="^", label=ax2labels[1])
ax2.set_title(ax2title)
ax2.legend()
ax2.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save to file
plt.tight_layout()
plt.savefig("multidiff_33.pdf", bbox_inches="tight")
