

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.gridspec import GridSpec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate sample data for the histogram representing test scores in two subjects
math_scores = np.random.normal(loc=75, scale=15, size=1000)  # Average of 75 in math
english_scores = np.random.normal(loc=70, scale=20, size=1000)  # Average of 70 in English

# Generate sample data for the scatter plot representing student performance metrics
homework_scores = np.random.normal(80, 10, 100)
exam_scores = np.random.normal(85, 12, 100)
project_scores = np.random.normal(78, 15, 100)

ax1title = "Histogram of Test Scores"
ax1xlabel = "Scores"
ax1ylabel = "Frequency"
ax1legend = ["Math", "English"]
ax2title = "Student Performance Metrics"
ax2labels = ["Homework vs Exams", "Projects vs Exams"]
xlabel="Performance Metric 1 (Homework/Projects)"
ylabel="Performance Metric 2 (Exams)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Histogram for test scores
fig = plt.figure(figsize=(12, 6))
gs = GridSpec(1, 2, figure=fig)

ax1 = fig.add_subplot(gs[0, 0])
ax1.hist(
    [math_scores, english_scores], bins=50, stacked=True, color=["#FF6F61", "#6B5B95"], alpha=0.7
)
ax1.set_title(ax1title)
ax1.set_xlabel(ax1xlabel)
ax1.set_ylabel(ax1ylabel)
ax1.legend(ax1legend)

# Scatter plot for student performance metrics
ax2 = fig.add_subplot(gs[0, 1])
ax2.scatter(homework_scores, exam_scores, c="#FF6F61", label=ax2labels[0], alpha=0.7, edgecolors='w', s=100)
ax2.scatter(project_scores, exam_scores, c="#6B5B95", label=ax2labels[1], alpha=0.7, edgecolors='w', s=100)
ax2.set_title(ax2title)
ax2.set_xlabel(xlabel)
ax2.set_ylabel(ylabel)
ax2.legend()
ax2.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save to file
plt.tight_layout()
plt.savefig("multidiff_34.pdf", bbox_inches="tight")
