

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# GDP growth rate data (example)
years = np.arange(1960, 2021, 5)
gdp_growth = np.random.normal(2, 1.5, len(years))  # mean 2%, std dev 1.5%

# Economic model grid for 3D surface plot (hypothetical interaction between interest rates and inflation)
X = np.arange(0, 20, 0.5)
Y = np.arange(0, 20, 0.5)
X, Y = np.meshgrid(X, Y)
Z = np.cos(X) * np.sin(Y)  # Hypothetical model

# Axes Limits and Labels
ylabel_value_1 = "GDP Growth Rate (%)"
xlabel_value_1 = "Year"

zlim_values = [-1, 1]
xlabel_value_2 = "Interest Rate (%)"
ylabel_value_2 = "Inflation Rate (%)"
zlabel_value_2 = "Economic Indicator Value"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up a figure twice as tall as it is wide
fig = plt.figure(figsize=(8, 10))

# First subplot
ax = fig.add_subplot(2, 1, 1)
ax.plot(years, gdp_growth, "bs-", markerfacecolor="red", label="GDP Growth")
ax.grid(True)
ax.set_ylabel(ylabel_value_1)
ax.set_xlabel(xlabel_value_1)
ax.legend()

# Second subplot
ax = fig.add_subplot(2, 1, 2, projection="3d")
surf = ax.plot_surface(X, Y, Z, cmap='coolwarm', rstride=1, cstride=1, linewidth=0, antialiased=False)
ax.set_zlim(zlim_values)
ax.set_xlabel(xlabel_value_2)
ax.set_ylabel(ylabel_value_2)
ax.set_zlabel(zlabel_value_2)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show the plot
plt.savefig("multidiff_35.pdf", bbox_inches="tight")
