

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Define functions to simulate weather data
def temperature(t):
    return 10 + 10 * np.sin(2 * np.pi * t / 24) + np.random.normal(0, 2, len(t))

# Time intervals
t1 = np.arange(0.0, 48.0, 1.0)  # Every hour for 2 days
t2 = np.arange(0.0, 48.0, 0.5)  # Every half hour for 2 days

# 3D Data for precipitation levels
X = np.arange(-5, 5, 0.25)
Y = np.arange(-5, 5, 0.25)
X, Y = np.meshgrid(X, Y)
Z = np.exp(-0.1 * (X**2 + Y**2)) * np.cos(X * Y)

# Axes Limits and Labels
ylabel_value_1 = "Temperature (°C)"
xlabel_value_1 = "Time (hours)"

zlim_values = [0.0, 1.0]
xlabel_value_2 = "Longitude"
ylabel_value_2 = "Latitude"
zlabel_value_2 = "Precipitation (mm)"
labels = ["Hourly Data", "Half-hour Data"]
titles = ["Temperature Trends Over Time", "3D Surface Plot of Precipitation Levels"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up a figure twice as tall as it is wide
fig = plt.figure(figsize=(8, 10))

# First subplot for temperature trends
ax = fig.add_subplot(2, 1, 1)
ax.plot(t1, temperature(t1), "bo-", label=labels[0], markerfacecolor="blue")
ax.plot(t2, temperature(t2), "g--", label=labels[1], linewidth=2)
ax.grid(True)
ax.set_ylabel(ylabel_value_1)
ax.set_xlabel(xlabel_value_1)
ax.legend(loc="best")
ax.set_title(titles[0])

# Second subplot for 3D surface plot of precipitation levels
ax = fig.add_subplot(2, 1, 2, projection="3d")
surf = ax.plot_surface(X, Y, Z, cmap="viridis", edgecolor='k', rstride=1, cstride=1, linewidth=0, antialiased=False)
ax.set_zlim(zlim_values)
ax.set_xlabel(xlabel_value_2)
ax.set_ylabel(ylabel_value_2)
ax.set_zlabel(zlabel_value_2)
ax.set_title(titles[1])

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show the plot
plt.savefig("multidiff_37.pdf", bbox_inches="tight")

