

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Importing necessary library
import numpy as np

np.random.seed(42)

# Leagues for the plots
leagues1 = [
    "NBA",
    "NFL",
    "MLB",
    "NHL",
    "MLS",
    "EPL",
]
leagues2 = [
    "EPL",
    "MLS",
    "NHL",
    "MLB",
    "NFL",
    "NBA",
]

# Number of teams in each league
teams = [30, 32, 30, 31, 27, 20]
fan_attendance = [17.5, 18.6, 22.9, 20.4, 19.3, 14.6]

# Differences in teams across years
teams_diff = np.array(
    [
        [0, -2, 0, -1, 3, 10],
        [2, 0, 2, 1, 5, 12],
        [0, -2, 0, -1, 3, 10],
        [1, -1, 1, 0, 4, 11],
        [-3, -5, -3, -4, 0, 7],
        [-10, -12, -10, -11, -7, 0],
    ]
)
fan_attendance_diff = np.array(
    [
        [0, -1.1, -0.3, -2.9, -1.8, 2.9],
        [1.1, 0, 0.8, -1.8, -0.7, 4.0],
        [0.3, -0.8, 0, -2.6, -1.5, 3.2],
        [2.9, 1.8, 2.6, 0, 1.1, 5.8],
        [1.8, 0.7, 1.5, -1.1, 0, 4.7],
        [-2.9, -4.0, -3.2, -5.8, -4.7, 0],
    ]
)
teams_growth_rate = np.array(
    [
        [0, 0.2, -0.1, 0.3, 0.1, 0.4],
        [-0.2, 0, 0.1, 0.2, 0.4, 0.5],
        [0.1, -0.1, 0, 0.4, 0.3, 0.6],
        [-0.3, -0.2, -0.4, 0, 0.2, 0.3],
        [-0.1, -0.4, -0.3, 0.2, 0, 0.5],
        [-0.4, -0.5, -0.6, -0.3, -0.5, 0],
    ]
)
fan_attendance_growth_rate = np.array(
    [
        [0, 0.3, -0.2, 0.4, 0.2, 0.5],
        [-0.3, 0, 0.1, 0.3, 0.1, 0.6],
        [0.2, -0.1, 0, 0.5, 0.3, 0.7],
        [-0.4, -0.3, -0.5, 0, 0.4, 0.5],
        [-0.2, -0.1, -0.3, 0.4, 0, 0.6],
        [-0.5, -0.6, -0.7, -0.5, -0.6, 0],
    ]
)
titles = [
    "Number of Teams",
    "Fan Attendance (millions)",
    "Teams Diff. (number)",
    "Fan Attendance Diff. (millions)",
    "Teams Growth Rate (%)",
    "Fan Attendance Growth Rate (%)",
]
xlim1 = [0, 40]
xlim2 = [0, 25]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, axs = plt.subplots(2, 3, figsize=(12, 8))

bar_color1 = "#66c2a5"
bar_color2 = "#fc8d62"
cmap1 = "coolwarm"
cmap2 = "YlGnBu"
cmap3 = "YlOrBr"

# Plot Number of Teams
axs[0, 0].barh(leagues1, teams, color=bar_color1)
axs[0, 0].set_title(titles[0])
axs[0, 0].set_xlim(xlim1)
axs[0, 0].invert_yaxis()
# annotate the bars with the values
for i, v in enumerate(teams):
    axs[0, 0].text(v + 1, i, str(v), color="black", va="center")

# Plot Fan Attendance
axs[1, 0].barh(leagues2, fan_attendance, color=bar_color2)
axs[1, 0].set_title(titles[1])
axs[1, 0].set_xlim(xlim2)
axs[1, 0].invert_yaxis()
# annotate the bars with the values
for i, v in enumerate(fan_attendance):
    axs[1, 0].text(v + 1, i, str(v), color="black", va="center")

# Plot Teams Diff.
im1 = axs[0, 1].imshow(teams_diff, cmap=cmap1, aspect="auto")
axs[0, 1].set_title(titles[2])
for i in range(len(leagues1)):
    for j in range(len(leagues1)):
        text = axs[0, 1].text(
            j,
            i,
            teams_diff[i, j],
            ha="center",
            va="center",
            color="black" if abs(teams_diff[i, j]) < 5 else "white",
        )
axs[0, 1].axis("off")

# Plot Fan Attendance Diff.
im2 = axs[1, 1].imshow(fan_attendance_diff, cmap=cmap1, aspect="auto")
axs[1, 1].set_title(titles[3])
for i in range(len(leagues2)):
    for j in range(len(leagues2)):
        text = axs[1, 1].text(
            j,
            i,
            fan_attendance_diff[i, j],
            ha="center",
            va="center",
            color="black" if abs(fan_attendance_diff[i, j]) < 3 else "white",
        )
axs[1, 1].axis("off")

# Plot Teams Growth Rate
im3 = axs[0, 2].imshow(teams_growth_rate, cmap=cmap2, aspect="auto")
axs[0, 2].set_title(titles[4])
for i in range(len(leagues1)):
    for j in range(len(leagues1)):
        text = axs[0, 2].text(
            j,
            i,
            teams_growth_rate[i, j],
            ha="center",
            va="center",
            color="black" if abs(teams_growth_rate[i, j]) < 0.3 else "white",
        )
axs[0, 2].axis("off")

# Plot Fan Attendance Growth Rate
im4 = axs[1, 2].imshow(fan_attendance_growth_rate, cmap=cmap3, aspect="auto")
axs[1, 2].set_title(titles[5])
for i in range(len(leagues2)):
    for j in range(len(leagues2)):
        text = axs[1, 2].text(
            j,
            i,
            fan_attendance_growth_rate[i, j],
            ha="center",
            va="center",
            color="black" if abs(fan_attendance_growth_rate[i, j]) < 0.5 else "white",
        )
axs[1, 2].axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("multidiff_44.pdf", bbox_inches="tight")

