
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Research Fields and corresponding data
fields = ["Physics", "Chemistry", "Biology", "Mathematics", "Computer Science", "Geology"]
publications = [120, 150, 180, 90, 200, 110]  # Number of publications
citations_per_publication = [50, 45, 60, 40, 55, 42]  # Average citations per publication

# Difference Matrices
publications_diff = np.random.uniform(-20, 20, (6, 6))
citations_diff = np.random.uniform(-10, 10, (6, 6))
peer_reviews = np.random.uniform(0, 20, (6, 6))
year_over_year_growth = np.random.uniform(-10, 10, (6, 6))

# Titles and Labels
titles = [
    "Number of Publications",
    "Average Citations per Publication",
    "Publications Difference",
    "Citations per Publication Difference",
    "Unfavorable Peer Reviews (%)",
    "Year-Over-Year Growth (%)"
]
xlim1 = [0, 250]
xlim2 = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, axs = plt.subplots(2, 3, figsize=(15, 10))

# Plot Number of Publications
axs[0, 0].barh(fields, publications, color="skyblue")
axs[0, 0].set_title(titles[0])
axs[0, 0].set_xlim(xlim1)
axs[0, 0].invert_yaxis()  # Reverse the order
for i, v in enumerate(publications):
    axs[0, 0].text(v + 2, i, str(v), color="black", va="center")

# Plot Average Citations per Publication
axs[1, 0].barh(fields, citations_per_publication, color="salmon")
axs[1, 0].set_title(titles[1])
axs[1, 0].set_xlim(xlim2)
axs[1, 0].invert_yaxis()  # Reverse the order
for i, v in enumerate(citations_per_publication):
    axs[1, 0].text(v + 2, i, str(v), color="black", va="center")

# Plot Publications Difference
im1 = axs[0, 1].imshow(publications_diff, cmap="coolwarm", aspect="auto")
axs[0, 1].set_title(titles[2])
for i in range(len(fields)):
    for j in range(len(fields)):
        text = axs[0, 1].text(
            j,
            i,
            round(publications_diff[i, j], 2),
            ha="center",
            va="center",
            color="black" if abs(publications_diff[i, j]) < 10 else "white",
        )
axs[0, 1].axis("off")

# Plot Citations per Publication Difference
im2 = axs[1, 1].imshow(citations_diff, cmap="coolwarm", aspect="auto")
axs[1, 1].set_title(titles[3])
for i in range(len(fields)):
    for j in range(len(fields)):
        text = axs[1, 1].text(
            j,
            i,
            round(citations_diff[i, j], 2),
            ha="center",
            va="center",
            color="black" if abs(citations_diff[i, j]) < 5 else "white",
        )
axs[1, 1].axis("off")

# Plot Unfavorable Peer Reviews
im3 = axs[0, 2].imshow(peer_reviews, cmap="coolwarm", aspect="auto")
axs[0, 2].set_title(titles[4])
for i in range(len(fields)):
    for j in range(len(fields)):
        text = axs[0, 2].text(
            j,
            i,
            round(peer_reviews[i, j], 2),
            ha="center",
            va="center",
            color="black" if peer_reviews[i, j] < 10 else "white",
        )
axs[0, 2].axis("off")

# Plot Year-Over-Year Growth
im4 = axs[1, 2].imshow(year_over_year_growth, cmap="coolwarm", aspect="auto")
axs[1, 2].set_title(titles[5])
for i in range(len(fields)):
    for j in range(len(fields)):
        text = axs[1, 2].text(
            j,
            i,
            round(year_over_year_growth[i, j], 2),
            ha="center",
            va="center",
            color="black" if abs(year_over_year_growth[i, j]) < 5 else "white",
        )
axs[1, 2].axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("multidiff_46.pdf", bbox_inches="tight")
