
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Assuming data values for the bar chart
cities = ["City A", "City B", "City C", "City D", "City E", "City F"]
avg_temperatures = [22.5, 25.0, 19.5, 18.0, 23.5, 21.0]

# Generate y values for the line chart with random variations representing monthly temperature changes
months = np.arange(1, 13)
temp_city1 = 20 + np.random.normal(0, 2, 12)
temp_city2 = 22 + np.random.normal(0, 2, 12)
temp_city3 = 19 + np.random.normal(0, 2, 12)
temp_city4 = 17 + np.random.normal(0, 2, 12)
temp_city5 = 21 + np.random.normal(0, 2, 12)
temp_city6 = 18 + np.random.normal(0, 2, 12)

# Axes Limits and Labels
xlabel_avg_temp = "Average Temperature (°C)"
xlim_avg_temp = [15, 30]
xticks_all_avg_temp = np.arange(15, 31, 1)
xticks_labeled_avg_temp = np.arange(15, 31, 5)

xlabel_temp_variation = "Month"
ylabel_temp_variation = "Temperature (°C)"
ylim_temp_variation = [10, 35]
xticks_all_temp_variation = months
xticks_labeled_temp_variation = months

label_city1 = "City A"
label_city2 = "City B"
label_city3 = "City C"
label_city4 = "City D"
label_city5 = "City E"
label_city6 = "City F"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create bar chart
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 12))
bar_colors = ["#2E8B57", "#66CDAA", "#48D1CC", "#20B2AA", "#5F9EA0", "#4682B4"]
ax1.barh(cities, avg_temperatures, color=bar_colors)
ax1.set_xlabel(xlabel_avg_temp)
ax1.set_xlim(xlim_avg_temp)

# Add more x-ticks but only label some of them
all_xticks = xticks_all_avg_temp
labeled_xticks = xticks_labeled_avg_temp
ax1.set_xticks(all_xticks)
ax1.set_xticklabels(
    [f"{tick:.1f}" if tick in labeled_xticks else "" for tick in all_xticks]
)

# Create line chart
trials = np.arange(1, 13)
ax2.plot(trials, temp_city1, label=label_city1, color="#FF6347", linestyle="-")
ax2.plot(trials, temp_city2, label=label_city2, color="#FFA07A", linestyle="--")
ax2.plot(trials, temp_city3, label=label_city3, color="#CD5C5C", linestyle="-.")
ax2.plot(trials, temp_city4, label=label_city4, color="#DC143C", linestyle=":")
ax2.plot(trials, temp_city5, label=label_city5, color="#B22222", linestyle="-")
ax2.plot(trials, temp_city6, label=label_city6, color="#8B0000", linestyle="--")
ax2.set_xlabel(xlabel_temp_variation)
ax2.set_ylabel(ylabel_temp_variation)

# Set the y limit to match the uploaded image aspect
ax2.set_ylim(ylim_temp_variation)
ax2.legend(loc="upper right", frameon=False)
all_xticks = xticks_all_temp_variation
labeled_xticks = xticks_labeled_temp_variation
ax2.set_xticks(all_xticks)
ax2.set_xticklabels(
    [f"{tick}" if tick in labeled_xticks else "" for tick in all_xticks]
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("multidiff_47.pdf", bbox_inches="tight")
