

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(1)

# Data for the bar chart
locations = [
    "City A",
    "City B",
    "City C",
    "City D",
    "City E",
    "City F",
    "City G",
]
rainfall = [75.4, 83.6, 65.8, 78.9, 62.1, 69.7, 58.3]  # Average annual rainfall in cm

# Data for the heatmap
population_flow_matrix = np.array(
    [
        [0.00, 1200, 900, 1250, 1100, 850, 750],
        [1350, 0.00, 1050, 1000, 1250, 950, 900],
        [950, 1000, 0.00, 1150, 1100, 800, 700],
        [1100, 1050, 1150, 0.00, 1200, 900, 850],
        [1050, 1000, 1100, 1200, 0.00, 850, 800],
        [950, 900, 850, 900, 850, 0.00, 750],
        [850, 800, 750, 850, 800, 750, 0.00],
    ]
)
ax1title = "Average Annual Rainfall (cm)"
ax2title = "Population Flow Matrix (people)"
ax1xlim = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(
    1, 2, figsize=(10, 6), gridspec_kw={"width_ratios": [1, 1.25]}
)

# Bar chart
y_pos = np.arange(len(locations))
bar_color = "#3498db"  # Bar color
ax1.barh(y_pos, rainfall, color=bar_color)
ax1.set_yticks(y_pos)
ax1.set_yticklabels(locations, fontsize=10)
ax1.invert_yaxis()  # labels read top-to-bottom
ax1.set_title(ax1title, fontsize=12)
ax1.set_xlim(ax1xlim)
for i, v in enumerate(rainfall):
    ax1.text(v - 5.0, i, "{:.1f}".format(v), color="white", va="center")

# Heatmap
im = ax2.imshow(population_flow_matrix, cmap="YlGnBu", aspect="auto")

# We want to show all ticks...
ax2.set_xticks(np.arange(len(locations)))
# ... and label them with the respective list entries
ax2.set_xticklabels(locations, fontsize=10)
ax2.yaxis.set_visible(False)

# Rotate the tick labels and set their alignment.
plt.setp(ax2.get_xticklabels(), rotation=45, ha="right", rotation_mode="anchor")

# Loop over data dimensions and create text annotations.
for i in range(len(locations)):
    for j in range(len(locations)):
        text = ax2.text(
            j, i, "{:.0f}".format(population_flow_matrix[i, j]), ha="center", va="center", color="black"
        )

ax2.set_title(ax2title, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("multidiff_57.pdf", bbox_inches="tight")

