
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Set the figure size and create a gridspec with different widths
plt.figure(figsize=(12, 6))
gs = gridspec.GridSpec(1, 3, width_ratios=[1, 1, 2])

# Data for bar plots (Life Expectancy and Average BMI)
countries = ["Country A", "Country B"]
life_expectancy = [76.5, 82.3]
average_bmi = [26.7, 28.4]
life_expectancy_bottom = [65.5, 70.7]  # Example bottom range
average_bmi_bottom = [20.3, 23.4]  # Example bottom range

# Data for line plot (Health Expenditure)
years = np.arange(2000, 2021, 1)
country_a_health_expenditure = np.random.normal(loc=1500, scale=200, size=len(years)).cumsum()
country_b_health_expenditure = np.random.normal(loc=1800, scale=250, size=len(years)).cumsum()
titles = ["(A) Average Life Expectancy", "(B) Average BMI", "(C) Health Expenditure Trends"]
ax1ylabel = "Years"
ax3labels = [
    "Country A Health Expenditure",
    "Country B Health Expenditure"
]
ax3xlabel = "Year"
ax3xticks = [2000, 2005, 2010, 2015, 2020]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Life Expectancy Bar Plot
color1 = "#6a994e"
color2 = "#f4a261"
ax1 = plt.subplot(gs[0])
ax1.bar(countries, life_expectancy, color=[color1, color2])
ax1.bar(countries, life_expectancy_bottom, color=["#95d5b2", "#f9c74f"])
ax1.set_title(titles[0])
ax1.set_ylabel(ax1ylabel)
ax1.set_ylim(0, 100)
for i, v in enumerate(life_expectancy):
    ax1.text(i, v - 5, str(v), color="black", ha="center")
for i, v in enumerate(life_expectancy_bottom):
    ax1.text(i, v - 5, str(v), color="black", ha="center")

# Average BMI Bar Plot
color3 = "#e76f51"
color4 = "#264653"
ax2 = plt.subplot(gs[1])
ax2.bar(countries, average_bmi, color=[color3, color4])
ax2.bar(countries, average_bmi_bottom, color=["#f4a261", "#2a9d8f"])
ax2.set_title(titles[1])
ax2.set_ylim(0, 50)
for i, v in enumerate(average_bmi):
    ax2.text(i, v - 2, str(v), color="black", ha="center")
for i, v in enumerate(average_bmi_bottom):
    ax2.text(i, v - 2, str(v), color="black", ha="center")

# Remove y-axis labels for the second plot
ax2.set_yticklabels([])

# Line plot for health expenditure trends
color5 = "#6a994e"
color6 = "#264653"
ax3 = plt.subplot(gs[2])
ax3.plot(
    years,
    country_a_health_expenditure,
    "g-o",
    label=ax3labels[0],
    color=color5,
    markersize=4,
)
ax3.plot(
    years,
    country_b_health_expenditure,
    "b-s",
    label=ax3labels[1],
    color=color6,
    markersize=4,
)
ax3.set_title(titles[2])
ax3.set_xlabel(ax3xlabel)
ax3.set_xticks(ax3xticks)
ax3.legend(loc="upper left", bbox_to_anchor=(1, 1), fontsize=8, frameon=False)
ax3.set_yticklabels([])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("multidiff_59.pdf", bbox_inches="tight")
