

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Set the figure size and create a gridspec with different widths
plt.figure(figsize=(12, 6))
gs = gridspec.GridSpec(1, 3, width_ratios=[1, 1, 2])

# Data for bar plots
categories = ["Banking", "Retail"]
banking_growth = [0.55, 0.6]
retail_growth = [0.65, 0.7]
banking_market_share = [0.35, 0.4]
retail_market_share = [0.45, 0.5]

# Data for line plot
months = np.arange(0, 361, 30)
banking_stock = [
    80, 85, 88, 90, 95, 100, 102, 98, 94, 97, 99, 102, 105
]
retail_stock = [
    70, 75, 78, 82, 84, 89, 92, 88, 85, 87, 89, 93, 96
]
energy_sector = [
    60, 68, 72, 75, 78, 80, 82, 81, 79, 82, 85, 87, 90
]
pharma_sector = [
    65, 70, 73, 77, 80, 83, 86, 84, 81, 83, 85, 88, 92
]
titles = ["(A) Banking Sector Performance", "(B) Retail Sector Performance", "(C) Stock Prices Over Time"]
ax1ylabel = "Performance Metrics"
ax3labels = [
    "Banking Stock",
    "Retail Stock",
    "Energy Sector",
    "Pharma Sector",
]
ax3xlabel = "Months"
ax3xticks = [0, 180, 360]
ax3vlines = [0, 180, 360]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar plot for Banking Sector
bar_colors = {
    "growth": ["#82caff", "#aaffc3"],
    "market_share": ["#3399ff", "#00ff99"]
}

ax1 = plt.subplot(gs[0])
ax1.bar(categories, banking_growth, color=bar_colors["growth"])
ax1.bar(categories, banking_market_share, color=bar_colors["market_share"])
ax1.set_title(titles[0])
ax1.set_ylabel(ax1ylabel)
ax1.set_ylim(0, 1)
for i, v in enumerate(banking_growth):
    ax1.text(i, v - 0.05, f"{v:.2f}", color="black", ha="center", fontsize=8)
for i, v in enumerate(banking_market_share):
    ax1.text(i, v - 0.05, f"{v:.2f}", color="black", ha="center", fontsize=8)

# Bar plot for Retail Sector
ax2 = plt.subplot(gs[1])
ax2.bar(categories, retail_growth, color=bar_colors["growth"])
ax2.bar(categories, retail_market_share, color=bar_colors["market_share"])
ax2.set_title(titles[1])
ax2.set_ylim(0, 1)
for i, v in enumerate(retail_growth):
    ax2.text(i, v - 0.05, f"{v:.2f}", color="black", ha="center", fontsize=8)
for i, v in enumerate(retail_market_share):
    ax2.text(i, v - 0.05, f"{v:.2f}", color="black", ha="center", fontsize=8)

# Remove y-axis labels for the second plot
ax2.set_yticklabels([])

# Line plot for stock prices over time - with double the width
line_colors = {
    "banking": "#ff6347",
    "retail": "#4682b4",
    "energy": "#3cb371",
    "pharma": "#20b2aa"
}

ax3 = plt.subplot(gs[2])
ax3.plot(
    months,
    banking_stock,
    "r-x",
    label=ax3labels[0],
    color=line_colors["banking"],
    markersize=5,
)
ax3.plot(
    months,
    retail_stock,
    "b-o",
    label=ax3labels[1],
    color=line_colors["retail"],
    markersize=5,
)
ax3.plot(
    months,
    energy_sector,
    "g-^",
    label=ax3labels[2],
    color=line_colors["energy"],
    markersize=5,
)
ax3.plot(
    months,
    pharma_sector,
    "c-s",
    label=ax3labels[3],
    color=line_colors["pharma"],
    markersize=5,
)
ax3.set_title(titles[2])
ax3.set_xlabel(ax3xlabel)
ax3.set_xticks(ax3xticks)
ax3.legend(loc="upper right", bbox_to_anchor=(0.95, 1.0), fontsize=8, frameon=False)
ax3.vlines(ax3vlines, 0, 120, colors="k", linestyles="dashed", linewidth=0.75)
ax3.set_yticklabels([])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("multidiff_60.pdf", bbox_inches="tight")

