
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(9)
# Set the figure size and create a gridspec with different widths
plt.figure(figsize=(10, 4))
gs = gridspec.GridSpec(1, 3, width_ratios=[1, 1, 2])

# Data for bar plots
companies = ["Company X", "Company Y"]
company_x_returns = [0.15, 0.25]
company_y_returns = [0.18, 0.22]
company_x_volatility = [0.08, 0.10]
company_y_volatility = [0.12, 0.11]

# Data for line plot
months = np.arange(0, 13, 1)
company_x_returns_progress = [0.10, 0.12, 0.14, 0.15, 0.16, 0.17, 0.18, 0.19, 0.20, 0.21, 0.22, 0.23, 0.24]
company_y_returns_progress = [0.08, 0.09, 0.10, 0.11, 0.12, 0.13, 0.14, 0.15, 0.16, 0.17, 0.18, 0.19, 0.20]
company_x_volatility_progress = [0.10, 0.09, 0.08, 0.08, 0.07, 0.07, 0.06, 0.06, 0.05, 0.05, 0.04, 0.04, 0.03]
company_y_volatility_progress = [0.12, 0.12, 0.11, 0.11, 0.10, 0.10, 0.09, 0.09, 0.08, 0.08, 0.07, 0.07, 0.06]

titles = ["(A) Company Returns", "(B) Volatility", "(C) Performance Over Time"]
ax1ylabel = "Returns"
ax3labels = [
    "Company X Returns",
    "Company Y Returns",
    "Company X Volatility",
    "Company Y Volatility",
]
ax3xlabel = "Months"
ax3xticks = [0, 6, 12]
ax3vlines = [0, 6, 12]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar plot for Company Returns
ax1 = plt.subplot(gs[0])
ax1.bar(companies, company_x_returns, color=["#70ad47", "#4472c4"])
ax1.bar(companies, company_x_volatility, color=["#a9d08e", "#a9c4de"])
ax1.set_title(titles[0])
ax1.set_ylabel(ax1ylabel)
ax1.set_ylim(0, 0.3)
for i, v in enumerate(company_x_returns):
    ax1.text(i, v - 0.015, str(v), color="black", ha="center")
for i, v in enumerate(company_x_volatility):
    ax1.text(i, v - 0.015, str(v), color="black", ha="center")

# Bar plot for Company Volatility
ax2 = plt.subplot(gs[1])
ax2.bar(companies, company_y_returns, color=["#5b9bd5", "#ffbf00"])
ax2.bar(companies, company_y_volatility, color=["#9cc3e5", "#ffd966"])
ax2.set_title(titles[1])
ax2.set_ylim(0, 0.3)
for i, v in enumerate(company_y_returns):
    ax2.text(i, v - 0.015, str(v), color="black", ha="center")
for i, v in enumerate(company_y_volatility):
    ax2.text(i, v - 0.015, str(v), color="black", ha="center")

# Remove y-axis labels for the second plot
ax2.set_yticklabels([])

# Line plot for Performance Over Time - with double the width
ax3 = plt.subplot(gs[2])
ax3.plot(
    months,
    company_x_returns_progress,
    "g-x",
    label=ax3labels[0],
    color="#70ad47",
    markersize=4,
)
ax3.plot(
    months,
    company_y_returns_progress,
    "b-o",
    label=ax3labels[1],
    color="#4472c4",
    markersize=4,
)
ax3.plot(
    months,
    company_x_volatility_progress,
    "g-x",
    label=ax3labels[2],
    color="#a9d08e",
    markersize=4,
)
ax3.plot(
    months,
    company_y_volatility_progress,
    "b-o",
    label=ax3labels[3],
    color="#a9c4de",
    markersize=4,
)
ax3.set_title(titles[2])
ax3.set_xlabel(ax3xlabel)
ax3.set_xticks(ax3xticks)
ax3.legend(loc="upper right", bbox_to_anchor=(0.95, 1.0), fontsize=6, frameon=False)
ax3.vlines(ax3vlines, 0, 0.3, colors="k", linestyles="dashed", linewidth=0.5)
ax3.set_yticklabels([])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("multidiff_61.pdf", bbox_inches="tight")
