

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for the line plot
x = np.array([2000, 2005, 2010, 2015, 2020])
y = np.array([150, 200, 250, 300, 350])
error = np.array([15, 10, 20, 15, 10])

# Sample data for the box plot
data = [np.random.normal(75, 10, 100) for _ in range(5)]
positions = x
# Add scatter data points
scatters_data = np.random.normal(80, 5, len(positions))

# Text label parameters
titles = ["(a) Student Enrollment Over Time", "(b) Exam Score Distribution"]
xlabels = ["Year", "Year"]
ylabels = ["Number of Students Enrolled", "Exam Score"]
xtickslabels = [
    ["2000", "2005", "2010", "2015", "2020"],
    ["2000", "2005", "2010", "2015", "2020"],
]
yticks = [np.arange(100, 401, 50), np.arange(50, 101, 10)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, axs = plt.subplots(2, 1, figsize=(7, 8))

# Line plot
axs[0].errorbar(
    x,
    y,
    yerr=error,
    fmt="o-",
    ecolor="lightblue",
    markersize=8,
    linewidth=1.5,
    color="blue",
    markerfacecolor="blue",
)
axs[0].fill_between(x, y - error, y + error, color="lightblue", alpha=0.5)
axs[0].set_title(titles[0], fontsize=14, fontweight='bold')
axs[0].set_xlabel(xlabels[0], fontsize=12)
axs[0].set_ylabel(ylabels[0], fontsize=12)
axs[0].grid(True, linestyle='--', alpha=0.7)
axs[0].set_xticks(x)
axs[0].set_xticklabels(xtickslabels[0])
axs[0].set_yticks(yticks[0])

# Box plot
axs[1].boxplot(
    data,
    positions=positions,
    widths=2,
    showfliers=False,
    boxprops=dict(color="darkred", linewidth=2),
    medianprops=dict(color="darkred", linewidth=2),
    whiskerprops=dict(color="darkred", linewidth=2),
    capprops=dict(color="darkred", linewidth=2),
)
axs[1].set_title(titles[1], fontsize=14, fontweight='bold')
axs[1].set_xlabel(xlabels[1], fontsize=12)
axs[1].set_ylabel(ylabels[1], fontsize=12)
axs[1].yaxis.grid(True, linestyle='--', alpha=0.7)
axs[1].set_xticks(positions)
axs[1].set_xticklabels(xtickslabels[1])
axs[1].set_yticks(yticks[1])

axs[1].scatter(positions, scatters_data, marker="^", color="darkred", s=100, zorder=3)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("multidiff_66.pdf", bbox_inches="tight")

