
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Data for bar plot
categories = ["Sunny", "Rainy", "Cloudy"]
values = [0.5, 0.3, 0.2]

# Data for heatmap
data = np.array(
    [[25.0, 28.0, 27.0, 26.0], [30.0, 32.0, 31.0, 29.0], [22.0, 20.0, 21.0, 23.0]]
)
rows = ["Morning", "Afternoon", "Evening"]
columns = ["Monday", "Tuesday", "Wednesday", "Thursday"]
ylabel = "Weather Proportion"
xlabel_bar = "Weather Type"
ylabel_heatmap = "Temperature (°C)"
title = "Distribution of Weather Types"
supertitle = "Weekly Weather Analysis"
color_bar = "#88CCEE"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(12, 5))
plt.suptitle(supertitle, fontsize=16)

# Create the bar plot on the left
plt.subplot(1, 2, 1)
bars = plt.bar(categories, values, color="#117733")
plt.ylabel(ylabel)
plt.xlabel(xlabel_bar)
plt.ylim([0, 0.6])
plt.title(title)

# Create the heatmap on the right
plt.subplot(1, 2, 2)
heatmap = plt.imshow(
    data, cmap="BuGn", interpolation="nearest", vmin=15, vmax=35
)
plt.xticks(np.arange(len(columns)), columns, rotation=30, ha="right")
plt.yticks(np.arange(len(rows)), rows)
plt.colorbar(heatmap, label="Temperature (°C)")
plt.xlabel("Days of the Week")
plt.ylabel(ylabel_heatmap)

# Annotate the heatmap with text
for i in range(len(rows)):
    for j in range(len(columns)):
        plt.text(j, i, f"{data[i, j]:.1f}", ha="center", va="center", color="black")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap
plt.tight_layout(rect=[0, 0, 1, 0.96])

plt.savefig("multidiff_69.pdf", bbox_inches="tight")
