

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for Area Chart - Represents communication metrics by year
years = ["2015", "2016", "2017", "2018", "2019", "2020"]
internet_penetration = np.array([50, 60, 70, 78, 85, 90])
mobile_penetration = np.array([40, 50, 60, 70, 80, 85])
fixed_line_penetration = np.array([20, 25, 30, 35, 40, 42])

# Cumulative data for the stacked Area chart
cumulative_internet_penetration = internet_penetration
cumulative_mobile_penetration = cumulative_internet_penetration + mobile_penetration
cumulative_fixed_line_penetration = cumulative_mobile_penetration + fixed_line_penetration

# Data for Bar Chart - Shows the number of publications by communication sub-domain
sub_domains = [
    "Telecommunications",
    "Networking",
    "Signal Processing",
    "Broadcasting",
    "Satellite",
    "Internet of Things",
    "Wireless Communication",
]
publications = [160, 180, 200, 140, 120, 150, 170]
titles = ["Communication Metrics Over Years", "Number of Publications by Communication Sub-Domain"]
xlabels = ["Year", "Sub-Domain"]
ylabels = ["Cumulative Metrics (%)", "Publications"]
ax1labels = ["Internet Penetration", "Mobile Penetration", "Fixed Line Penetration"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Creating the subplot layout
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 6))

# Plotting the Area Chart
ax1.fill_between(
    years, 0, cumulative_internet_penetration, label=ax1labels[0], color="#3B9D3B", alpha=0.6
)
ax1.fill_between(
    years,
    cumulative_internet_penetration,
    cumulative_mobile_penetration,
    label=ax1labels[1],
    color="#A67C00",
    alpha=0.6,
)
ax1.fill_between(
    years,
    cumulative_mobile_penetration,
    cumulative_fixed_line_penetration,
    label=ax1labels[2],
    color="#FFD700",
    alpha=0.6,
)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.legend(loc="upper left")

# Plotting the Bar Chart
ax2.bar(sub_domains, publications, color="#6B8E23")
ax2.set_title(titles[1])
ax2.set_xlabel(xlabels[1])
ax2.set_ylabel(ylabels[1])
ax2.set_xticklabels(sub_domains, rotation=45)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout and saving the figure
plt.tight_layout()
plt.savefig("multidiff_74.pdf", bbox_inches="tight")
