

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for Area Chart
years = ["2015", "2016", "2017", "2018", "2019", "2020", "2021", "2022"]
roadways = np.array([60, 58, 55, 53, 50, 48, 45, 42])
railways = np.array([45, 44, 43, 42, 41, 40, 39, 38])
air_travel = np.array([30, 32, 34, 36, 38, 40, 42, 45])

# Data for Box Plot
data_bus = np.random.normal(70, 15, 100)
data_train = np.random.normal(60, 10, 100)
data_airplane = np.random.normal(80, 20, 100)
data_ferry = np.random.normal(50, 15, 100)
data = [data_bus, data_train, data_airplane, data_ferry]

# Labels and Titles
sector_labels = ["Roadways", "Railways", "Air Travel"]
titles = [
    "Traffic Congestion Levels Over Time",
    "Average Passenger Load across Transportation Methods",
]
xlabels = ["Year"]
boxplot_xtickslabels = ["Bus", "Train", "Airplane", "Ferry"]
ylabels = ["Congestion Index", "Passenger Load (%)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots in a vertical layout
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 12))

# Cumulative sector values for the stacked area chart
cumulative_roadways = roadways
cumulative_railways = cumulative_roadways + railways
cumulative_air_travel = cumulative_railways + air_travel

# Plotting Area Chart
ax1.fill_between(
    years, 0, cumulative_roadways, label=sector_labels[0], color="#4caf50", alpha=0.7
)
ax1.fill_between(
    years,
    cumulative_roadways,
    cumulative_railways,
    label=sector_labels[1],
    color="#2196f3",
    alpha=0.7,
)
ax1.fill_between(
    years,
    cumulative_railways,
    cumulative_air_travel,
    label=sector_labels[2],
    color="#ff9800",
    alpha=0.7,
)

ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.legend(loc="upper left")
ax1.grid(True, linestyle='--', alpha=0.6)

# Creating Box Plot for Average Passenger Load
bp = ax2.boxplot(data, patch_artist=True, notch=False, showfliers=True)

# Customizing boxplot colors
colors = ["#4caf50", "#2196f3", "#ff9800", "#f44336"]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)
for median in bp["medians"]:
    median.set(color="black", linewidth=1.5)

# Setting labels and titles
ax2.set_xticklabels(boxplot_xtickslabels)
ax2.set_ylabel(ylabels[1])
ax2.set_title(titles[1])
ax2.yaxis.grid(True, linestyle='--', alpha=0.6)
ax2.spines["top"].set_visible(False)
ax2.spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("multidiff_77.pdf", bbox_inches="tight")
