

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(0)

# Stock Prices Data
companies = ["Apple", "Google", "Microsoft", "Amazon", "Tesla", "Netflix"]
stock_prices = [150, 120, 135, 160, 200, 190]  # hypothetical values in dollars
price_error = [10, 8, 9, 11, 12, 10]  # standard error values

# Stock Returns Data
investment_types = ["Bonds", "Mutual Funds", "ETFs", "Real Estate", "Stocks"]
return_means = np.random.uniform(5, 15, len(investment_types))
return_std_devs = np.random.uniform(1, 5, len(investment_types))
dataset_mean = np.mean(return_means)

# Labels
titles = [
    "Average Stock Prices by Company",
    "Annual Investment Returns by Type"
]
ylabels = [
    "Stock Prices (USD)",
    "Return Percentage (%)"
]

ylim = [0, 20]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes for the subplots
fig, axes = plt.subplots(2, 1, figsize=(10, 12))

# Colors
bar_color = "#87ceeb"
errorbar_color = "#32cd32"
line_color = "grey"

# Stock Prices Bar Plot
axes[0].bar(
    companies, stock_prices, yerr=price_error, color=bar_color, capsize=5, ecolor="black"
)
axes[0].set_title(titles[0])
axes[0].set_ylabel(ylabels[0])
axes[0].grid(True)

# Stock Returns Error Point Plot
axes[1].errorbar(
    investment_types,
    return_means,
    yerr=return_std_devs,
    fmt="o",
    color=errorbar_color,
    ecolor=errorbar_color,
    capsize=5,
    ms=10,
)
axes[1].axhline(y=dataset_mean, color=line_color, linestyle="--")
axes[1].set_title(titles[1])
axes[1].set_ylabel(ylabels[1])
axes[1].set_ylim(ylim)
axes[1].grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to avoid overlap and save the figure
plt.tight_layout()
plt.savefig("multidiff_81.pdf", bbox_inches="tight")

