

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Redefined data for Area Chart - Global average temperatures over decades
decades = ["1980s", "1990s", "2000s", "2010s"]
region_a = np.array([14.1, 14.3, 14.5, 14.9])  # Temperatures in Region A
region_b = np.array([13.8, 14.0, 14.2, 14.7])  # Temperatures in Region B
region_c = np.array([14.0, 14.2, 14.4, 14.8])  # Temperatures in Region C

# Adjust the cumulative calculation for clarity in visualization
cumulative_region_a = region_a
cumulative_region_b = cumulative_region_a + region_b
cumulative_region_c = cumulative_region_b + region_c

# New data for Bar Chart - Age group distribution in population
age_groups = ["0-14", "15-24", "25-54", "55-64", "65+"]
population_counts = [1200, 800, 2000, 600, 500]  # Population in thousands

# Redefined data for Histogram - Distribution of temperatures
urban_temps = np.random.normal(75, 10, 1000)  # Urban temperatures in Fahrenheit
rural_temps = np.random.normal(70, 15, 1000)  # Rural temperatures in Fahrenheit
bins = np.linspace(40, 100, 30)  # Uniform bin size for both histograms
ax1labels = ["Region A", "Region B", "Region C"]
titles = [
    "Global Average Temperatures Over Decades",
    "Age Group Distribution in Population",
    "Temperature Distribution by Region",
]
xlabels = ["Decade", "Age Group", "Temperature (°F)"]
ylabels = ["Average Temperature (°C)", "Population (Thousands)", "Frequency"]
ax3label=["Urban Temperatures", "Rural Temperatures"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with subplots
fig, (ax1, ax2, ax3) = plt.subplots(1, 3, figsize=(15, 5))

# Plotting the Area Chart with new data
ax1.stackplot(
    decades,
    cumulative_region_a,
    cumulative_region_b,
    cumulative_region_c,
    labels=ax1labels,
    colors=["#d73027", "#fc8d59", "#fee08b"],
    alpha=0.85,
)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.legend(loc="upper left")

# Plotting the Bar Chart with new data
ax2.bar(age_groups, population_counts, color="#91bfdb")
ax2.set_title(titles[1])
ax2.set_xlabel(xlabels[1])
ax2.set_ylabel(ylabels[1])
ax2.set_xticklabels(age_groups, rotation=40, ha='right')

# Plotting two overlapping Histograms
ax3.hist(urban_temps, bins=bins, color="#4575b4", alpha=0.6, label=ax3label[0])
ax3.hist(rural_temps, bins=bins, color="#d73027", alpha=0.6, label=ax3label[1])
ax3.set_title(titles[2])
ax3.set_xlabel(xlabels[2])
ax3.set_ylabel(ylabels[2])
ax3.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot as a PDF file
plt.tight_layout()
plt.savefig("multidiff_86.pdf", bbox_inches="tight")

