
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Setting a random seed for reproducibility
np.random.seed(0)

# Redefined data for Area Chart - Sports Participation Growth Over Time
years = ["2015", "2016", "2017", "2018", "2019", "2020", "2021", "2022"]
track_and_field = np.array([15, 20, 25, 30, 35, 40, 45, 50])
basketball = np.array([10, 15, 20, 25, 30, 35, 40, 45])
soccer = np.array([25, 30, 35, 40, 45, 50, 55, 60])

# Adjust the cumulative calculation for clarity in visualization
cumulative_track = track_and_field
cumulative_basketball = cumulative_track + basketball
cumulative_soccer = cumulative_basketball + soccer

# New data for Bar Chart - Popularity of Sports
sports = ["Soccer", "Basketball", "Baseball", "Tennis", "Swimming"]
popularity = [300, 250, 200, 150, 100]

# Redefined data for Histogram - Age distribution in urban vs rural areas for soccer
urban_ages = np.random.normal(25, 5, 1000)
rural_ages = np.random.normal(30, 7, 1000)
bins = np.linspace(10, 50, 30)  # Uniform bin size for both histograms

# Labels and titles
ax1labels = ["Track and Field", "Basketball", "Soccer"]
titles = [
    "Sports Participation Growth Over Time",
    "Popularity of Sports",
    "Age Distribution in Urban vs Rural Areas for Soccer",
]
xlabels = ["Year", "Sport", "Age"]
ylabels = ["Total Participation (%)", "Number of Votes", "Frequency"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with subplots
fig, (ax1, ax2, ax3) = plt.subplots(1, 3, figsize=(15, 5))

# Plotting the Area Chart with new data
ax1.stackplot(
    years,
    cumulative_track,
    cumulative_basketball,
    cumulative_soccer,
    labels=ax1labels,
    colors=["#66c2a5", "#fc8d62", "#8da0cb"],
    alpha=0.8,
)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.legend(loc="upper left")

# Plotting the Bar Chart with different data
ax2.bar(sports, popularity, color="#8e99f3")
ax2.set_title(titles[1])
ax2.set_xlabel(xlabels[1])
ax2.set_ylabel(ylabels[1])
ax2.set_xticklabels(sports, rotation=45)

# Plotting two overlapping Histograms
ax3.hist(urban_ages, bins=bins, color="#66c2a5", alpha=0.7, label="Urban Ages")
ax3.hist(rural_ages, bins=bins, color="#fc8d62", alpha=0.7, label="Rural Ages")
ax3.set_title(titles[2])
ax3.set_xlabel(xlabels[2])
ax3.set_ylabel(ylabels[2])
ax3.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot as a PDF file
plt.tight_layout()
plt.savefig("multidiff_87.pdf", bbox_inches="tight")
