
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from matplotlib.gridspec import GridSpec
from matplotlib.lines import Line2D


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# Create a figure and a GridSpec layout
fig = plt.figure(figsize=(10, 5))
gs = GridSpec(1, 2, figure=fig)

# ------- Pie Chart Data for Population Distribution -------
age_groups = ["0-14", "15-24", "25-54", "55-64", "65+"]
population_sizes = [27, 16, 41, 8, 8]  # Percentages of each age group

explode = (0.1, 0, 0, 0, 0)  # Highlight 0-14 age group

# ------- Radar Chart Data for Social Indicators -------
indicators = np.array(["Literacy", "Employment", "Healthcare Access", "Housing Quality", "Internet Access"])
num_vars = len(indicators)
indicator_values = np.array([0.94, 0.81, 0.87, 0.76, 0.91])
indicator_values = np.concatenate((indicator_values, [indicator_values[0]]))
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()
angles += angles[:1]

title_1 = "Population Distribution by Age Group"
title_2 = "Social Indicators"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#ff6666", "#66ccff", "#ffcc66", "#99ff99", "#c266ff"]

# Create the pie chart in the left panel
ax1 = fig.add_subplot(gs[0, 0])
wedges, texts, autotexts = ax1.pie(
    population_sizes,
    labels=age_groups,
    colors=colors,
    autopct="%1.1f%%",
    startangle=140,
    explode=explode,
)
ax1.set_title(title_1)
ax1.axis("equal")  # Equal aspect ratio ensures that pie is drawn as a circle.

# Create the radar chart in the right panel
ax2 = fig.add_subplot(gs[0, 1], polar=True)
ax2.fill(angles, indicator_values, color="#1f77b4", alpha=0.25)
ax2.plot(angles, indicator_values, color="#1f77b4", linewidth=1.5, linestyle='-', marker='o')

ax2.set_xticks(angles[:-1])
ax2.set_xticklabels(indicators)
ax2.set_title(title_2)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("multidiff_96.pdf", bbox_inches="tight")
