
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np  # Placing import in Part 2 as per requirement
np.random.seed(42)

# New Data for Picture in Picture bar plot
known_temps = np.array(
    [30, 28, 26, 24, 22, 20, 18, 16, 14, 12, 10]
)
unknown_temps = np.array(
    [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5]
)
bins = np.linspace(0, 0.5, 11)

# New Data for the heatmap
region_temps = np.array(
    [
        [20, 22, 25, 27, 29, 31],
        [18, 21, 24, 28, 30, 32],
        [15, 19, 23, 26, 28, 30],
        [13, 17, 22, 25, 27, 29],
        [10, 14, 20, 23, 26, 28],
    ]
)
x_labels = [
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
]
y_labels = ["North", "South", "East", "West", "Central"]
bar_labels = ["Known Temps", "Unknown Temps"]
xlabels = ["Temperature Range", "Months"]
ylabels = ["Temperature (°C)", "Regions"]
cbarlabel = "Average Temperature (°C)"
insetaxes = [0.28, 0.6, 0.1, 0.2]
insetxlim = [0.25, 0.5]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with GridSpec
fig = plt.figure(figsize=(14, 6))
gs = gridspec.GridSpec(1, 2, width_ratios=[1, 1.5])

# Picture in Picture bar plot
bar_color_known = "#ffb6c1"  # Color for known temperatures
bar_color_unknown = "#87cefa"  # Color for unknown temperatures
ax0 = plt.subplot(gs[0])
ax0.bar(
    bins,
    known_temps,
    width=0.04,
    color=bar_color_known,
    align="center",
    label=bar_labels[0],
    edgecolor="black",
)
ax0.bar(
    bins,
    unknown_temps,
    width=0.04,
    color=bar_color_unknown,
    align="center",
    bottom=known_temps,
    label=bar_labels[1],
    edgecolor="black",
)
ax0.set_xlabel(xlabels[0])
ax0.set_ylabel(ylabels[0])
ax0.legend(loc="upper right")
ax0.grid(True)

# Add inset
ax_inset = fig.add_axes(insetaxes)
ax_inset.bar(
    bins[5:],
    known_temps[5:],
    width=0.04,
    color=bar_color_known,
    align="center",
    edgecolor="black",
)
ax_inset.bar(
    bins[5:],
    unknown_temps[5:],
    width=0.04,
    color=bar_color_unknown,
    align="center",
    bottom=known_temps[5:],
    edgecolor="black",
)
ax_inset.set_xlim(insetxlim)

# Heatmap plot
ax1 = plt.subplot(gs[1])
cmap = plt.cm.viridis
norm = plt.Normalize(vmin=region_temps.min(), vmax=region_temps.max())
heatmap = ax1.imshow(region_temps, cmap=cmap, norm=norm, aspect="auto")

# Add color bar
cbar = plt.colorbar(heatmap, ax=ax1, orientation="vertical", pad=0.1)
cbar.set_label(cbarlabel)

# Set x and y labels
ax1.set_xticks(np.arange(len(x_labels)))
ax1.set_yticks(np.arange(len(y_labels)))
ax1.set_xticklabels(x_labels, rotation=45)
ax1.set_yticklabels(y_labels)
ax1.set_xlabel(xlabels[1])
ax1.set_ylabel(ylabels[1])

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("multidiff_99.pdf", bbox_inches="tight")
