

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data to plot
sizes = [20, 15, 10, 25, 20, 10]
labels = ['Ancient', 'Medieval', 'Renaissance', 'Modern', 'Contemporary', 'Postmodern']
colors = ["#e41a1c", "#377eb8", "#4daf4a", "#984ea3", "#ff7f00", "#ffff33"]

title = "Distribution of Philosophical Thought Schools"
legendlabels = labels

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
explode = (0.1, 0.1, 0.1, 0.1, 0.1, 0.1)  # add explode parameter to separate slices
# Plot
fig, ax = plt.subplots(figsize=(7, 7))
ax.pie(
    sizes,
    colors=colors,
    labels=labels,
    autopct="%1.1f%%",
    startangle=140,
    wedgeprops=dict(edgecolor="w"),
    explode=explode,
)

# Add title
plt.title(title, fontsize=16,pad=20)

# Add legend
ax.legend(legendlabels,ncol=6, loc="upper center",bbox_to_anchor=(0.5, 1.05))

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("pie_23.pdf", bbox_inches="tight")

