

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# New data for finance domain example
outer_labels = ["Technology 35%", "Healthcare 25%", "Finance 20%", "Energy 20%"]
inner_labels = ["Software", "Hardware", "Services"]

outer_sizes = [35, 25, 20, 20]  # Distribution of investment sectors
inner_sizes = [15, 10, 10]      # Breakdown of Technology sector

title = "Distribution of Investment Sectors"
suptitle = "Global Financial Portfolio"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6))

outer_colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]
inner_colors = ["#8c564b", "#e377c2", "#7f7f7f"]

# Outer ring
wedges, texts, autotexts = ax.pie(
    outer_sizes,
    labels=outer_labels,
    radius=1.2,
    colors=outer_colors,
    autopct="%1.1f%%",
    pctdistance=0.85,
    startangle=140,
    wedgeprops={"lw": 1, "edgecolor": "white"}
)

# Inner ring
wedges2, texts2, autotexts2 = ax.pie(
    inner_sizes,
    labels=inner_labels,
    radius=0.8,
    colors=inner_colors,
    autopct="%1.1f%%",
    pctdistance=0.75,
    startangle=140,
    wedgeprops={"lw": 1, "edgecolor": "white"}
)

# Equal aspect ratio ensures that pie chart is drawn as a circle
ax.axis("equal")

# Add a title and suptitle
plt.title(title, fontsize=14)
plt.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("pie_26.pdf", bbox_inches="tight")

