

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
labels = ["Solar 20%", "Wind 30%", "Hydro 25%", "Nuclear 25%"]
sizes = [20, 30, 25, 25]

title = "Energy Source Distribution"
output_filename = 'pie_30_4.pdf'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(5, 5))
colors = ['#ff9999','#66b3ff','#99ff99','#ffcc99']  # vibrant colors suitable for tourism
ax.pie(sizes, labels=labels, colors=colors, hatch=['//', '\\\\', '||', '++'], startangle=140)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_30.pdf", bbox_inches="tight")

