
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for personality distribution in a study sample
labels = ["Extrovert 30%", "Introvert 25%", "Ambivert 20%", "Analytical 25%"]
sizes = [30, 25, 20, 25]

# Chart text parameters
title = "Distribution of Different Personality Types in a Study Sample"
output_filename = "pie_31_2.pdf"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6))

# Custom color scheme
colors = ['#003f5c', '#58508d', '#bc5090', '#ff6361']

# Pie chart with updated styles
ax.pie(sizes, labels=labels, colors=colors, hatch=['*', 'o', '-', '.'], startangle=90)

plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_31.pdf", bbox_inches="tight")
