

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data to plot
labels = ["Asia", "Africa", "Europe", "North America", "South America"]
sizes = [60, 15, 10, 10, 5]

# Text label parameters
legend_labels = labels
legend_loc = "upper center"
legend_bbox_to_anchor = (0.5, 1.02)
legend_ncol = 5
legend_frameon = False

# Title
title = "Population Distribution by Continent"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
plt.figure(figsize=(8, 6))

# Color palette for continents
colors = ["#2a9d8f", "#e76f51", "#f4a261", "#e9c46a", "#264653"]

# Creating a pie chart with slight separation between segments
plt.pie(sizes, colors=colors, autopct="%1.05f%%", startangle=140, pctdistance=0.85, wedgeprops={'edgecolor': 'white', 'linewidth': 1})

# Equal aspect ratio ensures that pie is drawn as a circle
plt.axis("equal")

# Add title
plt.title(title, fontsize=14,pad=20)

# Add legend
plt.legend(
    legend_labels,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    frameon=legend_frameon,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("pie_36.pdf", bbox_inches="tight")
