

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data to plot
labels = ["Coal", "Natural Gas", "Hydropower", "Nuclear", "Renewables"]
sizes = [30.2, 24.3, 16.9, 10.6, 18.0]

# Text labels and settings
title = "Global Energy Sources Distribution"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
plt.figure(figsize=(10, 7))  # Adjust the figure size to be more readable
legend_labels = labels
legend_loc = "upper center"
legend_bbox_to_anchor = (0.5, 1.15)
legend_ncol = 3
legend_frameon = False

# Color scheme for political issues
colors = ["#377eb8", "#e41a1c", "#4daf4a", "#984ea3", "#ff7f00"]

# Create pie chart
plt.pie(sizes, colors=colors, autopct="%1.1f%%", shadow=False, startangle=140)
plt.axis("equal")  # Equal aspect ratio ensures that pie is drawn as a circle.

# Add title
plt.title(title, pad=20)

# Add legend
plt.legend(
    legend_labels,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    frameon=legend_frameon,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("pie_38.pdf", bbox_inches="tight")

