
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data to plot
labels = ["Windows", "macOS", "Linux", "Chrome OS", "Others"]
sizes = [76, 17, 2, 3, 2]

# Text label parameters
title = "Operating System Market Share"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
plt.figure(figsize=(8, 6))
colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0"]
explode = (0.1, 0, 0, 0, 0)
legend_labels = labels

plt.pie(
    sizes,
    explode=explode,
    colors=colors,
    autopct="%1.1f%%",
    shadow=True,
    startangle=140,
)
plt.axis("equal")

# Add legend
plt.legend(legend_labels, loc="upper left")
plt.title(title, fontsize=16, y=1.05)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("pie_41.pdf", bbox_inches="tight")
