

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# New data for religious distribution example
labels = ["Christianity", "Islam", "Hinduism", "Buddhism", "Other"]
outer_sizes = [31, 24, 15, 7, 23]  # Global religious distribution percentages
inner_sizes = [35, 30, 10, 5, 20]  # Regional religious distribution percentages

# Text and title settings
title = "Religious Distribution - Global vs. Regional"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6))

outer_colors = ["#4B0082", "#800080", "#9ACD32", "#32CD32", "#F0E68C"]
inner_colors = ["#8A2BE2", "#9370DB", "#ADFF2F", "#00FA9A", "#FAFAD2"]

explode_outer = (0.1, 0, 0, 0, 0)  # only explode the 1st slice (Christianity)

# Outer ring
wedges, texts, autotexts = ax.pie(
    outer_sizes,
    labels=labels,
    radius=1.2,
    colors=outer_colors,
    explode=explode_outer,
    autopct="%1.1f%%",
    pctdistance=0.85,
    startangle=160,
)

# Inner ring
wedges2, texts2, autotexts2 = ax.pie(
    inner_sizes,
    radius=0.8,
    colors=inner_colors,
    autopct="%1.1f%%",
    pctdistance=0.75,
    startangle=160,
)

# Equal aspect ratio ensures that pie chart is drawn as a circle
ax.axis("equal")

# Title for the double-layer pie chart
ax.set_title(title, fontsize=20, y=1.05)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("pie_46.pdf", bbox_inches="tight")

