
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
cities = [
    "New York: 1200 mm",
    "Los Angeles: 350 mm",
    "Chicago: 950 mm",
    "Houston: 1400 mm",
    "Phoenix: 200 mm",
    "Philadelphia: 1050 mm",
]

rainfall_data = [1200, 350, 950, 1400, 200, 1050]
title = "Annual Rainfall Distribution in Different Cities: A Donut"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 6), subplot_kw=dict(aspect="equal"))
colors = plt.cm.Paired(np.linspace(0, 1, len(rainfall_data)))
wedges, texts = ax.pie(rainfall_data, wedgeprops=dict(width=0.5, edgecolor='w'), startangle=-40, colors=colors, shadow=True)

bbox_props = dict(boxstyle="square,pad=0.3", fc="w", ec="k", lw=0.72)
kw = dict(arrowprops=dict(arrowstyle="->"), bbox=bbox_props, zorder=0, va="center")

for i, p in enumerate(wedges):
    ang = (p.theta2 - p.theta1) / 2.0 + p.theta1
    y = np.sin(np.deg2rad(ang))
    x = np.cos(np.deg2rad(ang))
    horizontalalignment = {-1: "right", 1: "left"}[int(np.sign(x))]
    connectionstyle = f"angle,angleA=0,angleB={ang}"
    kw["arrowprops"].update({"connectionstyle": connectionstyle})
    ax.annotate(
        cities[i],
        xy=(x, y),
        xytext=(1.35 * np.sign(x), 1.4 * y),
        horizontalalignment=horizontalalignment,
        **kw,
    )

ax.set_title(title, fontsize=14, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_48.pdf", bbox_inches="tight")
