

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for the charts
labels = ["Python", "JavaScript", "Java", "C++"]
pre_2010_data = [35, 30, 20, 15]
post_2010_data = [45, 35, 15, 5]

titles = ["Programming Languages Pre-2010", "Programming Languages Post-2010"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with specific dimensions
fig, ax = plt.subplots(1, 2, figsize=(10, 4))

colors = ["#4f6d7a", "#c0cad0", "#d49a89", "#a7c5bd"]

# Pre-2010 Programming Languages Donut Chart
explode1 = (0.1, 0, 0, 0)
ax[0].pie(
    pre_2010_data,
    labels=labels,
    colors=colors,
    startangle=140,
    counterclock=False,
    wedgeprops=dict(width=0.3, edgecolor='w'),
    explode=explode1,
    autopct="%1.1f%%",
    shadow=True
)
ax[0].set_title(titles[0], fontsize=14, fontweight='bold')

# Post-2010 Programming Languages Donut Chart
explode2 = (0, 0, 0.1, 0)
ax[1].pie(
    post_2010_data,
    labels=labels,
    colors=colors,
    startangle=140,
    counterclock=False,
    wedgeprops=dict(width=0.3, edgecolor='w'),
    explode=explode2,
    autopct="%1.1f%%",
    shadow=True
)
ax[1].set_title(titles[1], fontsize=14, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap and Show plot
plt.tight_layout()
plt.savefig("pie_54.pdf", bbox_inches="tight")

