

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for the charts
labels_sleep = ["Light Sleep", "Deep Sleep", "REM Sleep", "Awake"]
sleep_data = [50.0, 20.0, 25.0, 5.0]

labels_calories = ["Running", "Walking", "Cycling", "Swimming"]
calories_data = [500.0, 300.0, 400.0, 200.0]

titles = ["Sleep Stages Distribution", "Calories Burned by Activity"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with specific dimensions
fig, ax = plt.subplots(1, 2, figsize=(12, 6))

# Define color palettes
colors_sleep = ["#66c2a5", "#fc8d62", "#8da0cb", "#e78ac3"]
colors_calories = ["#a6d854", "#ffd92f", "#e5c494", "#b3b3b3"]

# Sleep Stages Donut Chart
explode1 = (0.1, 0, 0, 0)
ax[0].pie(
    sleep_data,
    labels=labels_sleep,
    colors=colors_sleep,
    startangle=140,
    counterclock=False,
    wedgeprops=dict(width=0.3),
    explode=explode1,
    autopct="%1.1f%%",
)
ax[0].set_title(titles[0])

# Calories Burned by Activity Donut Chart
explode2 = (0, 0.1, 0, 0.1)
ax[1].pie(
    calories_data,
    labels=labels_calories,
    colors=colors_calories,
    startangle=140,
    counterclock=False,
    wedgeprops=dict(width=0.3),
    explode=explode2,
    autopct="%1.1f%%",
)
ax[1].set_title(titles[1])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap and Show plot
plt.tight_layout()
plt.savefig("pie_56.pdf", bbox_inches="tight")

