
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the charts
categories = ["Coal", "Oil", "Natural Gas", "Nuclear"]
non_renewable_energy_data = [45, 30, 15, 10]
renewable_energy_data = ["Solar", "Wind", "Hydro", "Biomass"]
renewable_energy_data_values = [25, 35, 30, 10]

# Variables for plot configuration
non_renewable_energy_label = "Non-Renewable Energy Sources"
renewable_energy_label = "Renewable Energy Sources"
legend_labels = categories
legend_loc = "lower center"

title_non_renewable_energy = "Non-Renewable Energy Sources"
title_renewable_energy = "Renewable Energy Sources"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with specific dimensions
fig, ax = plt.subplots(2, 1, figsize=(7, 10))

# New color scheme for energy domain
colors = ["#5DADE2", "#48C9B0", "#F1948A", "#AF7AC5"]
legend_ncol = 4
legend_frameon = False
wedgeprops_dict = dict(width=0.3)
startangle = 90
counterclock = False

# Non-Renewable Energy Sources Donut Chart
ax[0].pie(
    non_renewable_energy_data,
    labels=non_renewable_energy_data,
    colors=colors,
    startangle=startangle,
    counterclock=counterclock,
    wedgeprops=wedgeprops_dict,
)
ax[0].set_title(title_non_renewable_energy)

# Renewable Energy Sources Donut Chart
ax[1].pie(
    renewable_energy_data_values,
    labels=renewable_energy_data_values,
    colors=colors,
    startangle=startangle,
    counterclock=counterclock,
    wedgeprops=wedgeprops_dict,
)
ax[1].set_title(title_renewable_energy)

# Add legend
fig.legend(legend_labels, loc=legend_loc, ncol=legend_ncol, frameon=legend_frameon)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap and Show plot
plt.tight_layout()
plt.savefig("pie_57.pdf", bbox_inches="tight")
