
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# New example data for the double layer donut chart
vals1 = [400, 300, 100, 200]
vals2 = [250, 50, 50, 50]
vals3 = [600]  # This will be the white center

# Define labels and colors
labels = ["Coal", "Natural Gas", "Nuclear", "Renewable"]

# Variables for plot configuration
title_text = "Energy Consumption by Source"
legend_labels = labels

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 6))

# Colors chosen to align with technology and communication themes
colors1 = ["#4D4DFF", "#1E90FF", "#9370DB", "#32CD32"]
colors2 = ["#87CEEB", "#B0E0E6", "#D8BFD8", "#98FB98"]

legend_bbox_to_anchor = (1, 0.8)
legend_frameon = False

# Outer donut chart
wedges1, texts1, autotexts1 = ax.pie(
    vals1,
    labels=labels,
    radius=1.1,
    colors=colors1,
    autopct="%1.1f%%",
    pctdistance=0.9,
    wedgeprops=dict(width=0.3, edgecolor="w"),
)

# Inner donut chart
wedges2, texts2, autotexts2 = ax.pie(
    vals2,
    radius=0.9,
    colors=colors2,
    autopct="%1.1f%%",
    pctdistance=0.75,
    wedgeprops=dict(width=0.3, edgecolor="w"),
)

# White center circle for the 'hole'
ax.pie(vals3, radius=0.6, colors="w", wedgeprops=dict(width=0.3, edgecolor="w"))

# Equal aspect ratio ensures that pie chart is drawn as a circle
ax.axis("equal")

# Title for the donut chart
ax.set_title(title_text)

# Show the plot with a legend
plt.legend(legend_labels, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_63.pdf", bbox_inches="tight")
