

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# New example data for the double layer donut chart in the population domain
vals1 = [400, 500, 200]  # External urban vs rural distribution
vals2 = [300, 400, 150]  # Internal urban distribution
vals3 = [700]  # This will be the white center

# Define labels and colors
labels = ["Children", "Adults", "Seniors"]

# Variables for plot configuration
title_text = "Population Distribution by Age Group - Urban vs. Rural"
legend_labels = labels

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 8))

colors1 = ["#FF6F61", "#6B5B95", "#88B04B"]
colors2 = ["#FFB3A7", "#B39EB5", "#BFD641"]

legend_bbox_to_anchor = (1.2, 1)
legend_frameon = False

# Outer donut chart
wedges1, texts1, autotexts1 = ax.pie(
    vals1,
    labels=labels,
    radius=1.2,
    colors=colors1,
    autopct="%1.1f%%",
    pctdistance=0.9,
    wedgeprops=dict(width=0.3, edgecolor="w"),
)

# Inner donut chart
wedges2, texts2, autotexts2 = ax.pie(
    vals2,
    radius=0.9,
    colors=colors2,
    autopct="%1.1f%%",
    pctdistance=0.75,
    wedgeprops=dict(width=0.3, edgecolor="w"),
)

# White center circle for the 'hole'
ax.pie(vals3, radius=0.6, colors="w", wedgeprops=dict(width=0.3, edgecolor="w"))

# Equal aspect ratio ensures that pie chart is drawn as a circle
ax.axis("equal")

# Title for the donut chart
ax.set_title(title_text, fontsize=14, fontweight='bold')

# Show the plot with a legend
plt.legend(legend_labels, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_64.pdf", bbox_inches="tight")

