

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data to plot
land_cover_types = ["Forests", "Urban Areas", "Agricultural Land", "Water Bodies", "Grasslands"]
land_cover_distribution = [40, 15, 30, 5, 10]  # Example data in percentage

# Plot configuration variables
title_text = "Land Cover Distribution in the Region (in %)"
xlabel_text = "Land Cover Types"
ylabel_text = "Percentage of Total Area"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
explode = (0.1, 0, 0, 0, 0)  # explode the first slice
colors = ["#f4a582", "#92c5de", "#d5e0e0", "#fee0b6", "#b2182b"]
title_pad = 20
title_fontsize = 18
legend_loc = "center left"
legend_bbox_to_anchor = (1, 0, 0.5, 1)
autopct_format = "%1.1f%%"
startangle = 140
wedgeprops = dict(edgecolor="k")

# Plot
fig, ax = plt.subplots(figsize=(10, 7))
ax.pie(
    land_cover_distribution,
    colors=colors,
    autopct=autopct_format,
    startangle=startangle,
    wedgeprops=wedgeprops,
    explode=explode,
)

# Adding a title and legend
ax.set_title(title_text, pad=title_pad, fontsize=title_fontsize)
ax.legend(land_cover_types, loc=legend_loc, bbox_to_anchor=legend_bbox_to_anchor)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("pie_66.pdf", bbox_inches="tight")

