

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data to plot
technologies = ["Smartphones", "Laptops", "Tablets", "Desktops", "Smartwatches", "Smart Speakers"]
usage_percentages = [40, 25, 10, 15, 5, 5]

# Plot configuration variables
title_text = "User Distribution Across Different Technologies (in %)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
explode = (0.1, 0, 0, 0, 0, 0.1)  # explode the first and last slices
colors = ["#4caf50", "#2196f3", "#ff5722", "#ffc107", "#9c27b0", "#03a9f4"]
title_pad = 20
title_fontsize = 18
legend_loc = "center left"
legend_bbox_to_anchor = (1, 0, 0.5, 1)
autopct_format = "%1.1f%%"
startangle = 140
wedgeprops = dict(edgecolor="k")

# Plot
fig, ax = plt.subplots(figsize=(10, 7))
ax.pie(
    usage_percentages,
    colors=colors,
    autopct=autopct_format,
    startangle=startangle,
    wedgeprops=wedgeprops,
    explode=explode,
)

# Adding a title and legend
ax.set_title(title_text, pad=title_pad, fontsize=title_fontsize)
ax.legend(technologies, loc=legend_loc, bbox_to_anchor=legend_bbox_to_anchor)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("pie_68.pdf", bbox_inches="tight")

