

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data to plot
sizes = [
    35,  # Healthcare
    25,  # Finance
    15,  # Retail
    15,  # Manufacturing
    10,  # Education
]
labels = ["Healthcare", "Finance", "Retail", "Manufacturing", "Education"]

# Plot configuration
title = "Technology Adoption in Different Industries"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
explode = (0.1, 0.1, 0.1, 0, 0.2)  # add explode parameter to separate slices
colors = ["#6baed6", "#2171b5", "#9ecae1", "#c6dbef", "#eff3ff"]

title_pad = 20
autopct_format = "%1.1f%%"
startangle = 90
wedgeprops = dict(edgecolor="w")
shadow = True

# Plot
fig, ax = plt.subplots(figsize=(7, 7))
ax.pie(
    sizes,
    colors=colors,
    autopct=autopct_format,
    startangle=startangle,
    wedgeprops=wedgeprops,
    explode=explode,
    labels=labels,
    shadow=shadow,
)
ax.set_title(title, pad=title_pad)  # Set the title with padding

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("pie_70.pdf", bbox_inches="tight")

